/*
* Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

package com.sun.ts.tests.jaspic.tssv.util;

import java.security.Principal;
import javax.security.auth.Subject;




/**
 *
 * @author Raja Perumal
 */
public class SimplePrincipal implements Principal, java.io.Serializable {
    private String name;      // username
    private String password;  // password


    public SimplePrincipal(String val, String pwd) {
        name = val;
        password = pwd;
    }

    // required to satisfy Principal interface
    public boolean equals(Object another) {
        if ((another != null) &&
            (another instanceof SimplePrincipal) &&
            (((SimplePrincipal)another).getName().equals(name))) {
            return true;
        } else {
            return false;
        }
    }

    // required to satisfy Principal interface
    public String getName() {
        return name;
    }

    // required to satisfy Principal interface
    public String toString() {
        return name;
    }

    // required to satisfy Principal interface
    public int hashCode() {
        return name.hashCode();
    }

    // XXXX:  may want to change this later if tests call for it
    // this is normally bad but for now we dont care 
    public String getPassword() {
        return password;
    }
}  // end of class SimulateRuntime
