/*
* Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

package com.sun.ts.tests.jaspic.spi.servlet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.annotation.security.DeclareRoles;



@DeclareRoles({"Administrator", "Manager", "Employee"})
@ServletSecurity( httpMethodConstraints = { @HttpMethodConstraint(value = "GET"),
                                            @HttpMethodConstraint(value = "POST") 
         })
@WebServlet(urlPatterns={"/OptionalAuthen", "/ModuleAuthStatusThrowExNoDispatch"})
public class OptionalAuthen extends HttpServlet {


    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        doPost( request, response);
        out.println("Enterred OptionalAuthen->doGet()");
    }
    

    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
    
        System.out.println("In OptionalAuthen->doPost()");

        PrintWriter out = response.getWriter();
        out.println("Enterred OptionalAuthen->doPost()");

        out.println("request.getServletPath() = " + request.getServletPath());
        out.println("request.getPathInfo() = " + request.getPathInfo());
        out.println("request.getMethod() = " + request.getMethod());
    }


    public void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        System.out.println("In OptionalAuthen->service()");
        PrintWriter out = response.getWriter();
        out.println("Enterred OptionalAuthen->service()");
    }

}

