/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: StatefulThreeTestBean.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.migration.threetwo;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;


@Stateful(name="StatefulThreeTestBean")
@Remote(ThreeTestIF.class)
public class StatefulThreeTestBean extends ThreeTestBeanBase implements ThreeTestIF {
    
    @EJB(name="twoRemoteHome")
    private TwoRemoteHome twoRemoteHome;
    
    //need to override it in ejb-jar.xml to provide the target ejb type info
    @EJB(name="twoLocalHome")
    //private TwoLocalHome twoLocalHome;
    private Object twoLocalHome;
    
    @Resource(name="sctx")
    private SessionContext sctx;
    
    public StatefulThreeTestBean() {
    }
    
    public void remove() {
    }

    protected TwoRemoteHome getTwoRemoteHome() {
        return (TwoRemoteHome) (sctx.lookup("twoRemoteHome"));
    }

    protected TwoLocalHome getTwoLocalHome() {
        return (TwoLocalHome) (sctx.lookup("twoLocalHome"));
    }

    protected javax.ejb.EJBContext getEJBContext() {
        return sctx;
    }
}
