/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Comparator.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.equals;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;

public class Comparator {
    
    private Comparator() {
    }
    
    public static void compare(Object one, Object two, boolean expected, boolean logIfOk) 
    throws TestFailedException {
        if(one.equals(two) == expected) {
            if(logIfOk) {
                TLogger.log("Comparing 2 beans returned " + expected +
                        ", as expected: bean1 (" + one + "), and bean2 (" +
                        two + ").");
            }
        } else {
            throw new TestFailedException("Expecting " + expected + " from comparing 2 beans, " +
                    "but got otherwise: bean1 (" + one + "), and bean2 (" +
                    two + ").");
        }
    }
    
    public static void compare(Object one, Object two, Object three, boolean expected, boolean logIfOk) 
    throws TestFailedException {
        boolean actual = one.equals(two) && two.equals(three);
        if(actual == expected) {
            if(logIfOk) {
                TLogger.log("Comparing 3 beans returned " + expected +
                        ", as expected: bean1 (" + one + "), and bean2 (" +
                        two + "), and bean3 (" + three + ").");
            }
        } else {
            throw new TestFailedException("Expecting " + expected + " from comparing 3 beans, " +
                    "but got otherwise: bean1 (" + one + "), and bean2 (" +
                    two + "), and bean3 (" + three + ").");
        }
    }
    
}
