/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * @(#)InterceptorF.java	1.1 06/02/07
 */

package com.sun.ts.tests.ejb30.common.callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.InvocationContext;

public class InterceptorH extends InterceptorF {
    public InterceptorH() {
        super();
    }
    
    @Override
    public String getInjectedLocation() {
        return NOT_INJECTED;
    }
    
    @Override
    protected String getShortName() { return "H";}
    
    @PostConstruct
    protected void myCreateInH(InvocationContext inv) throws RuntimeException {
        myCreate0(inv, "H");
    }
    
    @PreDestroy
    protected void myRemoveInH(InvocationContext inv) throws RuntimeException {
        myRemove0(inv);
    }

    @Override
    protected void myRemoveInF(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    protected void myRemoveInE(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    protected void myRemove(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    protected void myCreateInF(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    protected void myCreateInE(InvocationContext inv) throws RuntimeException {
    }

    @Override
    protected void myCreate(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }
    
}
