/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: RMIMBeanImpl.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

import java.util.*;
import java.io.*;
import javax.naming.InitialContext;
import javax.jbi.component.ComponentContext;

public class RMIMBeanImpl implements RMIMBean {

    private Integer port     = DEFAULT_RMI_PORT;
    private String  hostname = DEFAULT_RMI_HOST;
    private String  bindname = DEFAULT_RMI_BIND_NAME;

    public void setRmiPort(String port) {
	try {
	    this.port = new Integer(Integer.parseInt(port));
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
    
    public String getRmiPort() {
	return port.toString();
    }
    
    public void setRmiHost(String hostname) {
	this.hostname = hostname;
    }

    public String getRmiHost() {
	return hostname;
    }

    public void setRmiBindName(String bindname) {
	this.bindname = bindname;
    }

    public String getRmiBindName() {
	return bindname;
    }

    public void saveProps(ComponentContext ctx) throws Exception {
	InitialContext ictx = ctx.getNamingContext();
	ictx.rebind(Constants.RMI_PORT_NAME, port);
	ictx.rebind(Constants.RMI_HOST_NAME, hostname);
	ictx.rebind(Constants.RMI_BIND_NAME, bindname);
    }

    // instead of serializeProps -  Add a utility class with code to
    // that uses  reflection to get all the methods that start with get
    // and write them to a props file on disk.  This way we can persist any
    // MBean that has properties that need to be persisted from the boot strap
    // bean to the actual component.  Currently we only seem to have two
    // props: rmiHost and rmiPort.  Bu we may have more and this would be a
    // good way to persist them.

}
