/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import jdk.incubator.http.AuthenticationFilter;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.ExecutorWrapper;
import jdk.incubator.http.HeaderFilter;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.HttpResponseImpl;
import jdk.incubator.http.HttpTimeoutException;
import jdk.incubator.http.PushGroup;
import jdk.incubator.http.Response;
import jdk.incubator.http.TimeoutEvent;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.common.Utils8;

class MultiExchange<U, T> {
    private final HttpRequest userRequest;
    private final HttpRequestImpl request;
    final AccessControlContext acc;
    final HttpClientImpl client;
    final HttpResponse.BodyHandler<T> responseHandler;
    final ExecutorWrapper execWrapper;
    final Executor executor;
    final HttpResponse.MultiProcessor<U, T> multiResponseHandler;
    HttpRequestImpl currentreq;
    Exchange<T> exchange;
    Exchange<T> previous = null;
    int attempts;
    static final int DEFAULT_MAX_ATTEMPTS = 5;
    static final int max_attempts = Utils.getIntegerNetProperty("jdk.httpclient.redirects.retrylimit", 5);
    private final List<HeaderFilter> filters;
    TimedEvent timedEvent;
    volatile boolean cancelled;
    final PushGroup<U, T> pushGroup;
    volatile AuthenticationFilter.AuthInfo serverauth;
    volatile AuthenticationFilter.AuthInfo proxyauth;
    volatile int numberOfRedirects = 0;

    MultiExchange(HttpRequest httpRequest, HttpClientImpl httpClientImpl, HttpResponse.BodyHandler<T> bodyHandler) {
        this.userRequest = httpRequest;
        this.currentreq = this.request = new HttpRequestImpl(httpRequest);
        this.attempts = 0;
        this.client = httpClientImpl;
        this.filters = httpClientImpl.filterChain();
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        this.execWrapper = new ExecutorWrapper(httpClientImpl.executor(), this.acc);
        this.executor = this.execWrapper.executor();
        this.responseHandler = bodyHandler;
        this.exchange = new Exchange(this.request, this);
        this.multiResponseHandler = null;
        this.pushGroup = null;
    }

    MultiExchange(HttpRequest httpRequest, HttpClientImpl httpClientImpl, HttpResponse.MultiProcessor<U, T> multiProcessor) {
        this.userRequest = httpRequest;
        this.currentreq = this.request = new HttpRequestImpl(httpRequest);
        this.attempts = 0;
        this.client = httpClientImpl;
        this.filters = httpClientImpl.filterChain();
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        this.execWrapper = new ExecutorWrapper(httpClientImpl.executor(), this.acc);
        this.executor = this.execWrapper.executor();
        this.multiResponseHandler = multiProcessor;
        this.pushGroup = new PushGroup<U, T>(multiProcessor, this.request);
        this.exchange = new Exchange(this.request, this);
        this.responseHandler = this.pushGroup.mainResponseHandler();
    }

    public HttpResponseImpl<T> response() throws IOException, InterruptedException {
        HttpRequestImpl httpRequestImpl = this.request;
        if (httpRequestImpl.duration() != null) {
            this.timedEvent = new TimedEvent(httpRequestImpl.duration());
            this.client.registerTimer(this.timedEvent);
        }
        while (this.attempts < max_attempts) {
            try {
                ++this.attempts;
                Exchange<T> exchange = this.getExchange();
                this.requestFilters(httpRequestImpl);
                Response response = exchange.response();
                HttpRequestImpl httpRequestImpl2 = this.responseFilters(response);
                if (httpRequestImpl2 == null) {
                    if (this.attempts > 1) {
                        Log.logError("Succeeded on attempt: " + this.attempts, new Object[0]);
                    }
                    T t = exchange.readBody(this.responseHandler);
                    this.cancelTimer();
                    return new HttpResponseImpl<T>(this.userRequest, response, t, exchange);
                }
                this.setExchange(new Exchange(httpRequestImpl2, this, this.acc));
                httpRequestImpl = httpRequestImpl2;
            }
            catch (IOException iOException) {
                if (this.cancelled) {
                    throw new HttpTimeoutException("Request timed out");
                }
                throw iOException;
            }
        }
        this.cancelTimer();
        throw new IOException("Retry limit exceeded");
    }

    CompletableFuture<Void> multiCompletionCF() {
        return this.pushGroup.groupResult();
    }

    private synchronized Exchange<T> getExchange() {
        return this.exchange;
    }

    HttpClientImpl client() {
        return this.client;
    }

    HttpClient.Redirect followRedirects() {
        return this.client.followRedirects();
    }

    HttpClient.Version version() {
        return this.request.version().orElse(this.client.version());
    }

    private synchronized void setExchange(Exchange<T> exchange) {
        this.exchange = exchange;
    }

    private void cancelTimer() {
        if (this.timedEvent != null) {
            this.client.cancelTimer(this.timedEvent);
        }
    }

    private void requestFilters(HttpRequestImpl httpRequestImpl) throws IOException {
        Log.logTrace("Applying request filters", new Object[0]);
        for (HeaderFilter headerFilter : this.filters) {
            Log.logTrace("Applying {0}", headerFilter);
            headerFilter.request(httpRequestImpl, this);
        }
        Log.logTrace("All filters applied", new Object[0]);
    }

    private HttpRequestImpl responseFilters(Response response) throws IOException {
        Log.logTrace("Applying response filters", new Object[0]);
        for (HeaderFilter headerFilter : this.filters) {
            Log.logTrace("Applying {0}", headerFilter);
            HttpRequestImpl httpRequestImpl = headerFilter.response(response);
            if (httpRequestImpl == null) continue;
            Log.logTrace("New request: stopping filters", new Object[0]);
            return httpRequestImpl;
        }
        Log.logTrace("All filters applied", new Object[0]);
        return null;
    }

    public void cancel() {
        this.cancelled = true;
        this.getExchange().cancel();
    }

    public void cancel(IOException iOException) {
        this.cancelled = true;
        this.getExchange().cancel(iOException);
    }

    public CompletableFuture<HttpResponseImpl<T>> responseAsync() {
        MinimalFuture<Void> minimalFuture = new MinimalFuture<Void>();
        CompletableFuture<HttpResponseImpl<T>> completableFuture = this.responseAsync0(minimalFuture);
        Utils8.completeAsync(minimalFuture, () -> null, this.executor);
        return completableFuture;
    }

    private CompletableFuture<HttpResponseImpl<T>> responseAsync0(CompletableFuture<Void> completableFuture) {
        return ((CompletableFuture)completableFuture.thenCompose(void_ -> this.responseAsyncImpl())).thenCompose(response -> {
            Exchange<T> exchange = this.getExchange();
            return exchange.readBodyAsync(this.responseHandler).thenApply(object -> new HttpResponseImpl<Object>(this.userRequest, (Response)response, object, (Exchange<Object>)exchange));
        });
    }

    CompletableFuture<U> multiResponseAsync() {
        MinimalFuture<Void> minimalFuture = new MinimalFuture<Void>();
        CompletableFuture<HttpResponseImpl<T>> completableFuture = this.responseAsync0(minimalFuture);
        CompletionStage completionStage = completableFuture.thenApply(httpResponseImpl -> {
            this.multiResponseHandler.onResponse((HttpResponse<T>)httpResponseImpl);
            return httpResponseImpl;
        });
        this.pushGroup.setMainResponse((CompletableFuture<HttpResponse<T>>)completionStage);
        ((CompletableFuture)completionStage).thenAccept(httpResponse -> this.pushGroup.noMorePushes(true));
        CompletableFuture<U> completableFuture2 = this.multiResponseHandler.completion(this.pushGroup.groupResult(), this.pushGroup.pushesCF());
        Utils8.completeAsync(minimalFuture, () -> null, this.executor);
        return completableFuture2;
    }

    private CompletableFuture<Response> responseAsyncImpl() {
        CompletionStage<Response> completionStage;
        if (++this.attempts > max_attempts) {
            completionStage = MinimalFuture.failedFuture(new IOException("Too many retries"));
        } else {
            if (this.currentreq.duration() != null) {
                this.timedEvent = new TimedEvent(this.currentreq.duration());
                this.client.registerTimer(this.timedEvent);
            }
            try {
                this.requestFilters(this.currentreq);
            }
            catch (IOException iOException) {
                return MinimalFuture.failedFuture(iOException);
            }
            Exchange<T> exchange = this.getExchange();
            completionStage = ((CompletableFuture)((CompletableFuture)exchange.responseAsync().thenCompose(response -> {
                HttpRequestImpl httpRequestImpl = null;
                try {
                    httpRequestImpl = this.responseFilters((Response)response);
                }
                catch (IOException iOException) {
                    return MinimalFuture.failedFuture(iOException);
                }
                if (httpRequestImpl == null) {
                    if (this.attempts > 1) {
                        Log.logError("Succeeded on attempt: " + this.attempts, new Object[0]);
                    }
                    return MinimalFuture.completedFuture(response);
                }
                this.currentreq = httpRequestImpl;
                this.setExchange(new Exchange(this.currentreq, this, this.acc));
                return this.responseAsyncImpl();
            })).handle((response, throwable) -> {
                this.cancelTimer();
                if (throwable == null) {
                    assert (response != null);
                    return MinimalFuture.completedFuture(response);
                }
                CompletableFuture<Response> completableFuture = this.getExceptionalCF((Throwable)throwable);
                if (completableFuture == null) {
                    return this.responseAsyncImpl();
                }
                return completableFuture;
            })).thenCompose((Function)UnaryOperator.identity());
        }
        return completionStage;
    }

    private CompletableFuture<Response> getExceptionalCF(Throwable throwable) {
        if ((throwable instanceof CompletionException || throwable instanceof ExecutionException) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (this.cancelled && throwable instanceof IOException) {
            throwable = new HttpTimeoutException("request timed out");
        }
        return MinimalFuture.failedFuture(throwable);
    }

    class TimedEvent
    extends TimeoutEvent {
        TimedEvent(Duration duration) {
            super(duration);
        }

        @Override
        public void handle() {
            MultiExchange.this.cancel(new HttpTimeoutException("request timed out"));
        }
    }
}

