/*
* Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/
   
/*
 * $Id: XAMessageXAResource.java 62543 2011-04-15 16:55:11Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import javax.transaction.xa.*;
import com.sun.ts.tests.common.connector.util.*;


public class XAMessageXAResource implements XAResource {



    public XAMessageXAResource()
    {
            System.out.println("XAMessageXAResource constructor");
    }

    private void handleResourceException(Exception ex)
        throws XAException {

        XAException xae = new XAException(ex.toString());
        xae.errorCode = XAException.XAER_RMERR;
        throw xae;
    }  

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            System.out.println("XAMessageXAResource.commit");
        }
        catch (Exception ex) {
            handleResourceException(ex);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            System.out.println("XAMessageXAResource.start");
        } catch (Exception ex) {
            handleResourceException(ex);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
    	    System.out.println("XAMessageXAResource.end");
            //ConnectorStatus.getConnectorStatus().logAPI("MessageXAResource.end" , "", "");
        }catch (Exception ex) {
            handleResourceException(ex);
        }
    }
    
    public void forget(Xid xid) throws XAException {
       System.out.println("XAMessageXAResource.forget");
    }

    public int getTransactionTimeout() throws XAException {
        return 1;
    }
    
    public boolean isSameRM(XAResource other) throws XAException {
       System.out.println("XAMessageXAResource.isSameRM");
       return false;
    }        

    public int prepare(Xid xid) throws XAException {
        ConnectorStatus.getConnectorStatus().logAPI("XAMessageXAResource.prepare" , "", "");
    	System.out.println("XAMessageXAResource.prepare");
    	try{
            return XAResource.XA_OK;
        }
        catch (Exception ex)
        {
           handleResourceException(ex);
           return XAException.XAER_RMERR;
        }
    }
    
    public Xid[] recover(int flag) throws XAException {    	
            System.out.println("XAMessageXAResource.recover");      
            return null;      
    }
    
    public void rollback(Xid xid) throws XAException {
        try 
        {
    	    System.out.println("XAMessageXAResource.rollback");
        }
        catch (Exception ex) {
            handleResourceException(ex);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return true;
    }

}
