/*
* Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

/*
 * $Id: WorkListenerImpl.java 62543 2011-04-15 16:55:11Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import com.sun.ts.tests.common.connector.util.*;


public class WorkListenerImpl implements WorkListener
{
    private String uidStr = null;

    public void workAccepted(WorkEvent e)
    {
       if (uidStr == null) {
           ConnectorStatus.getConnectorStatus().logState("WorkListenerImpl.workAccepted");
       } else {
           ConnectorStatus.getConnectorStatus().logState("WorkListenerImpl.workAccepted for:" + uidStr);
       }
       debug("WorkListenerImpl.workAccepted"); 
    }
    
    public void workRejected(WorkEvent e)
    {
        ConnectorStatus.getConnectorStatus().logState("WorkListenerImpl.workRejected");
        debug("WorkListenerImpl.workRejected"); 
    }
    
    public void workStarted(WorkEvent e)
    {
        ConnectorStatus.getConnectorStatus().logState("WorkListenerImpl.workStarted");
        debug("WorkListenerImpl.workStarted"); 
    }
    public void workCompleted(WorkEvent e)
    {
        ConnectorStatus.getConnectorStatus().logState("WorkListenerImpl.workCompleted");
        debug("WorkListenerImpl.workCompleted"); 
    }

    public void setUidStr(String val) {
        this.uidStr = val;
    }

    public String getUidStr() {
        return this.uidStr;
    }

    private void debug (String str) {
        Debug.trace(str);
    }
}
