/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.TextWriter;
import java.io.File;
import java.io.IOException;
import java.util.Date;

class Trace
implements Harness.Observer {
    TextWriter out;
    File reportDir;
    BackupPolicy backupPolicy;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Trace.class);

    Trace(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    @Override
    public synchronized void startingTestRun(Parameters params) {
        this.openOutput(params);
        if (this.out != null) {
            TestSuite ts = params.getTestSuite();
            String tsName = ts == null ? "null" : ts.getClass().getName();
            TestFinder tf = params.getWorkDirectory().getTestResultTable().getTestFinder();
            String tfName = tf == null ? "null" : tf.getClass().getName();
            this.println(i18n, "trace.starting", new Object[]{tsName, tfName});
        }
    }

    @Override
    public synchronized void startingTest(TestResult tr) {
        if (this.out != null) {
            TestDescription td = null;
            try {
                td = tr.getDescription();
            }
            catch (TestResult.Fault e) {
                e.printStackTrace();
            }
            if (td != null) {
                this.println(i18n, "trace.testStarting", td.getRootRelativeURL());
            }
        }
    }

    @Override
    public synchronized void finishedTest(TestResult tr) {
        if (this.out != null) {
            try {
                TestDescription td = tr.getDescription();
                this.println(i18n, "trace.testFinished", new Object[]{td.getRootRelativeURL(), tr.getStatus()});
            }
            catch (TestResult.Fault e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void stoppingTestRun() {
        if (this.out != null) {
            this.println(i18n, "trace.stopping");
        }
    }

    @Override
    public synchronized void finishedTesting() {
        if (this.out != null) {
            this.println(i18n, "trace.cleanup");
        }
    }

    @Override
    public synchronized void finishedTestRun(boolean allOK) {
        if (this.out != null) {
            if (allOK) {
                this.println(i18n, "trace.doneOK");
            } else {
                this.println(i18n, "trace.doneNotOK");
            }
            this.close();
        }
    }

    @Override
    public synchronized void error(String s) {
        if (this.out != null) {
            this.println(i18n, "trace.error", s);
        }
    }

    private void openOutput(Parameters params) {
        try {
            WorkDirectory wd = params.getWorkDirectory();
            File traceFile = wd.getSystemFile("harness.trace");
            boolean autoFlush = Boolean.getBoolean("javatest.trace.autoflush");
            this.out = new TextWriter(this.backupPolicy.backupAndOpenWriter(traceFile));
            this.out.println("# Trace file started at " + new Date());
            this.out.println("# " + ProductInfo.getName() + " version " + ProductInfo.getVersion());
            this.out.println("# class directory: " + Harness.getClassDir());
            this.out.println("# using java: " + System.getProperty("java.home"));
        }
        catch (IOException e) {
            System.err.println("Cannot open trace file: trace cancelled");
            System.err.println(e);
            this.out = null;
        }
    }

    private void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                System.err.println("Exception occurred writing to trace file");
                System.err.println(e);
            }
            this.out = null;
        }
    }

    private void println(I18NResourceBundle i18n, String key) {
        this.printLocalizedLn(i18n.getString(key));
    }

    private void println(I18NResourceBundle i18n, String key, Object arg) {
        this.printLocalizedLn(i18n.getString(key, arg));
    }

    private void println(I18NResourceBundle i18n, String key, Object[] args) {
        this.printLocalizedLn(i18n.getString(key, args));
    }

    private void printLocalizedLn(String msg) {
        try {
            this.out.println(msg);
            this.out.flush();
        }
        catch (IOException e) {
            System.err.println("Exception occurred writing to trace file");
            System.err.println(e);
            System.err.println("while trying to write: " + msg);
        }
    }
}

