/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import jdk.incubator.http.internal.hpack.HeaderTable;
import jdk.incubator.http.internal.hpack.IndexNameValueWriter;

final class LiteralWithIndexingWriter
extends IndexNameValueWriter {
    private boolean tableUpdated;
    private CharSequence name;
    private CharSequence value;
    private int index;

    LiteralWithIndexingWriter() {
        super(64, 6);
    }

    @Override
    LiteralWithIndexingWriter index(int n) {
        super.index(n);
        this.index = n;
        return this;
    }

    @Override
    LiteralWithIndexingWriter name(CharSequence charSequence, boolean bl) {
        super.name(charSequence, bl);
        this.name = charSequence;
        return this;
    }

    @Override
    LiteralWithIndexingWriter value(CharSequence charSequence, boolean bl) {
        super.value(charSequence, bl);
        this.value = charSequence;
        return this;
    }

    @Override
    public boolean write(HeaderTable headerTable, ByteBuffer byteBuffer) {
        if (!this.tableUpdated) {
            CharSequence charSequence = this.indexedRepresentation ? headerTable.get((int)this.index).name : this.name;
            headerTable.put(charSequence, this.value);
            this.tableUpdated = true;
        }
        return super.write(headerTable, byteBuffer);
    }

    @Override
    public IndexNameValueWriter reset() {
        this.tableUpdated = false;
        this.name = null;
        this.value = null;
        this.index = -1;
        return super.reset();
    }
}

