/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.securityapi.idstore.multiauthz;

import static jakarta.security.enterprise.identitystore.IdentityStore.ValidationType.PROVIDE_GROUPS;
import static java.util.Arrays.asList;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;

/*
 * 
 */
@RequestScoped
public class IdentityStoreAuthz2 implements IdentityStore {

  private Map<String, Set<String>> userGroup;

  @PostConstruct
  public void init() {

    userGroup = new HashMap<>();
    userGroup.put("tom", new HashSet<>(asList("AdminAuthz2", "ManagerAuthz2")));
    userGroup.put("emma",
        new HashSet<>(asList("AdminAuthz2", "EmployeeAuthz2")));
    userGroup.put("bob", new HashSet<>(asList("AdminAuthz2")));

  }

  @Override
  public Set<String> getCallerGroups(
      CredentialValidationResult validationResult) {
    System.out.println("IDStoreAuthz2:getCallerGroups...");

    Set<String> groups = new HashSet<String>();
    groups.add("IDStoreAuthz2:getCallerGroups");
    groups
        .addAll(userGroup.get(validationResult.getCallerPrincipal().getName()));
    return groups;
  }

  @Override
  public int priority() {
    int priority = 100;
    return priority;
  }

  @Override
  public Set<ValidationType> validationTypes() {
    return EnumSet.of(PROVIDE_GROUPS);
  }

}
