/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.ClassSet;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Setup
extends SigTest {
    public static final String CLOSEDFILE_OPTION = "-ClosedFile";
    public static final String NONCLOSEDFILE_OPTION = "-NonClosedFile";
    public static final String CHECKVALUE_OPTION = "-CheckValue";
    public static final String XGENCONSTS_OPTION = "-XgenConsts";
    public static final String COPYRIGHT_OPTION = "-CopyRight";
    public static final String KEEP_SIGFILE_OPTION = "-KeepFile";
    public static final String XREFLECTION_OPTION = "-Xreflection";
    protected URL signatureFile;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Setup.class);
    protected boolean isClosedFile = true;
    private Boolean explicitlyGenConsts = null;
    private boolean keepSigFile = false;
    private String copyrightStr = null;
    private int outerClassesNumber = 0;
    private int innerClassesNumber = 0;
    private int includedClassesNumber = 0;
    private int excludedClassesNumber = 0;

    public static void main(String[] args) {
        Setup t = new Setup();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    public void run(String[] args, PrintWriter pw, PrintWriter ref) {
        this.setLog(pw);
        this.outerClassesNumber = 0;
        this.innerClassesNumber = 0;
        this.includedClassesNumber = 0;
        this.excludedClassesNumber = 0;
        MemberType.setMode(false);
        if (this.parseParameters(args)) {
            this.afterParseParameters();
            this.create(this.signatureFile);
            this.getLog().flush();
        } else if (args.length > 0 && Option.VERSION.accept(args[0])) {
            pw.println(Version.getVersionInfo());
        }
    }

    protected boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        if (args == null || args.length == 0 || args.length == 1 && Option.VERSION.accept(args[0])) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption("-ApiVersion", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ClassCacheSize", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-XnoTiger", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Xverbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Verbose", OptionInfo.optionVariableParams(0, 1), "decodeOptions");
        parser.addOption(CLOSEDFILE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(NONCLOSEDFILE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(KEEP_SIGFILE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(CHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(XGENCONSTS_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(XREFLECTION_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Plugin", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ErrorAll", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(COPYRIGHT_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOptions(bo.getOptions(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (!this.processHelpOptions()) {
            return false;
        }
        if (!parser.isOptionSpecified(XREFLECTION_OPTION)) {
            bo.readOptions(Option.STATIC.getKey(), null);
        }
        if (parser.isOptionSpecified(NONCLOSEDFILE_OPTION) && parser.isOptionSpecified(CLOSEDFILE_OPTION)) {
            return this.error(i18n.getString("Setup.error.mode.contradict", new Object[]{NONCLOSEDFILE_OPTION, CLOSEDFILE_OPTION}));
        }
        this.packages.addPackages(bo.getValues(Option.PACKAGE));
        this.purePackages.addPackages(bo.getValues(Option.PURE_PACKAGE));
        this.excludedPackages.addPackages(bo.getValues(Option.EXCLUDE));
        this.apiIncl.addPackages(bo.getValues(Option.API_INCLUDE));
        this.apiExcl.addPackages(bo.getValues(Option.API_EXCLUDE));
        if (this.packages.isEmpty() && this.purePackages.isEmpty() && this.apiIncl.isEmpty()) {
            this.packages.addPackage("");
        }
        if (bo.getValue(Option.FILE_NAME) == null) {
            return this.error(i18n.getString("MTest.error.filename.missing"));
        }
        if (bo.getValue(Option.TEST_URL) != null && new File(bo.getValue(Option.FILE_NAME)).isAbsolute()) {
            return this.error(i18n.getString("MTest.error.testurl.absolutepath", new Object[]{Option.TEST_URL.getKey(), bo.getValue(Option.FILE_NAME)}));
        }
        try {
            this.signatureFile = FileManager.getURL(bo.getValue(Option.TEST_URL), bo.getValue(Option.FILE_NAME));
        }
        catch (MalformedURLException e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            System.err.println(e);
            return this.error(i18n.getString("Setup.error.url.invalid"));
        }
        if (bo.getValue(Option.CLASSPATH) == null) {
            return this.error(i18n.getString("Setup.error.arg.unspecified", Option.CLASSPATH.getKey()));
        }
        return this.passed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(CLOSEDFILE_OPTION)) {
            this.isClosedFile = true;
            return;
        } else if (optionName.equalsIgnoreCase(NONCLOSEDFILE_OPTION)) {
            this.isClosedFile = false;
            return;
        } else if (optionName.equalsIgnoreCase(KEEP_SIGFILE_OPTION)) {
            this.keepSigFile = true;
            return;
        } else {
            if (optionName.equalsIgnoreCase(CHECKVALUE_OPTION)) return;
            if (optionName.equalsIgnoreCase(XGENCONSTS_OPTION)) {
                String v = args[0];
                if ("on".equalsIgnoreCase(v)) {
                    this.explicitlyGenConsts = Boolean.TRUE;
                    return;
                } else {
                    if (!"off".equalsIgnoreCase(v)) throw new CommandLineParserException(i18n.getString("Setup.error.arg.invalidval", XGENCONSTS_OPTION));
                    this.explicitlyGenConsts = Boolean.FALSE;
                }
                return;
            } else if (optionName.equalsIgnoreCase(COPYRIGHT_OPTION)) {
                this.copyrightStr = args[0];
                return;
            } else {
                super.decodeCommonOptions(optionName, args);
            }
        }
    }

    private void afterParseParameters() {
        if (this.explicitlyGenConsts != null) {
            this.setConstantValuesTracked(this.explicitlyGenConsts);
        } else {
            BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
            this.setConstantValuesTracked(bo.isSet(Option.STATIC));
        }
    }

    @Override
    protected void usage() {
        String nl = System.getProperty("line.separator");
        String sb = this.getComponentName() + " - " + i18n.getString("Setup.usage.version", "4.1") + nl + i18n.getString("Setup.usage.start") + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("Setup.usage.classpath", Option.CLASSPATH) + nl + i18n.getString("Setup.usage.package", Option.PACKAGE) + nl + i18n.getString("Setup.usage.filename", Option.FILE_NAME) + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("Setup.usage.testurl", Option.TEST_URL) + nl + i18n.getString("Setup.usage.packagewithoutsubpackages", Option.PURE_PACKAGE) + nl + i18n.getString("Setup.usage.exclude", Option.EXCLUDE) + nl + i18n.getString("Setup.usage.nonclosedfile", NONCLOSEDFILE_OPTION) + nl + i18n.getString("Setup.usage.apiversion", "-ApiVersion") + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("Setup.usage.verbose", new Object[]{"-Verbose", "nowarn"}) + nl + i18n.getString("Setup.usage.debug", Option.DEBUG) + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("Setup.helpusage.version", Option.VERSION) + nl + i18n.getString("Setup.usage.help", Option.HELP) + nl + i18n.getString("Sigtest.usage.delimiter") + nl + i18n.getString("Setup.usage.end");
        System.err.println(sb);
    }

    @Override
    protected String getComponentName() {
        return "Setup";
    }

    private boolean create(URL sigFile) {
        this.initErrors();
        if (this.pluginClass != null) {
            this.pluginClass.init(this);
        }
        HashSet<String> allClasses = new HashSet<String>();
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        this.getLog().println(i18n.getString("Setup.log.classpath", bo.getValue(Option.CLASSPATH)));
        try {
            this.setClasspath(new ClasspathImpl(bo.getValue(Option.CLASSPATH)));
        }
        catch (SecurityException e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            this.getLog().println(i18n.getString("Setup.log.invalid.security.classpath"));
            this.getLog().println(e);
            return this.error(i18n.getString("Setup.log.invalid.security.classpath"));
        }
        this.getClasspath().printErrors(this.getLog());
        TreeSet<String> excludedClasses = new TreeSet<String>();
        Classpath cp = this.getClasspath();
        Object object = null;
        try {
            List<String> sortedClasses;
            while (cp.hasNext()) {
                String name = cp.nextClassName();
                if (allClasses.add(name)) continue;
                this.getLog().println(i18n.getString("Setup.log.duplicate.class", name));
            }
            cp.setListToBegin();
            ClassDescriptionLoader testableLoader = this.getClassDescrLoader();
            this.testableHierarchy = new ClassHierarchyImpl(testableLoader);
            this.testableMCBuilder = new MemberCollectionBuilder(this, "source:setup");
            this.getLog().println(i18n.getString("Setup.log.constantchecking", this.isConstantValuesTracked() ? i18n.getString("Setup.msg.ConstantValuesTracked.on") : i18n.getString("Setup.msg.ConstantValuesTracked.off")));
            this.getLog().println(i18n.getString("Setup.log.message.numclasses", Integer.toString(allClasses.size())));
            Collection<String> packageClasses = this.getPackageClasses(allClasses);
            if (this.isClosedFile) {
                ClassSet closedSetOfClasses = new ClassSet(this.testableHierarchy, true);
                for (String name : packageClasses) {
                    closedSetOfClasses.addClass(name);
                }
                HashSet<String> invisibleClasses = new HashSet<String>();
                Set<String> classes = closedSetOfClasses.getClasses();
                for (String name : classes) {
                    ClassDescription c = this.load(name);
                    if (this.testableHierarchy.isAccessible(c)) continue;
                    invisibleClasses.add(name);
                }
                for (String invisibleClass : invisibleClasses) {
                    closedSetOfClasses.removeClass(invisibleClass);
                }
                sortedClasses = this.sortClasses(closedSetOfClasses.getClasses());
            } else {
                sortedClasses = this.sortClasses(packageClasses);
            }
            try {
                Writer writer = this.getFileManager().getDefaultFormat().getWriter();
                Object object2 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(sigFile.getFile());
                    Iterator iterator = null;
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                        writer.init(new PrintWriter(osw));
                        writer.setApiVersion(this.apiVersion);
                        if (this.isConstantValuesTracked()) {
                            writer.addFeature(FeaturesHolder.ConstInfo);
                        }
                        if (isTigerFeaturesTracked) {
                            writer.addFeature(FeaturesHolder.TigerInfo);
                        }
                        if (this.copyrightStr != null) {
                            FeaturesHolder.CopyRight.setText("# " + this.copyrightStr);
                            writer.addFeature(FeaturesHolder.CopyRight);
                        }
                        writer.writeHeader();
                        Erasurator erasurator = new Erasurator();
                        for (String name : sortedClasses) {
                            Filter f;
                            Transformer t;
                            ClassDescription c = this.load(name);
                            if (!this.testableHierarchy.isAccessible(c)) continue;
                            if (this.excludedPackages.checkName(name) || this.apiExcl.checkName(name)) {
                                excludedClasses.add(name);
                                continue;
                            }
                            if (name.indexOf(36) < 0) {
                                ++this.outerClassesNumber;
                            } else {
                                ++this.innerClassesNumber;
                            }
                            try {
                                this.testableMCBuilder.createMembers(c, this.addInherited(), true, false);
                                this.normalizer.normThrows(c, true);
                                this.removeUndocumentedAnnotations(c, this.testableHierarchy);
                            }
                            catch (ClassNotFoundException e) {
                                if (bo.isSet(Option.DEBUG)) {
                                    SwissKnife.reportThrowable(e);
                                }
                                this.setupProblem(i18n.getString("Setup.error.message.classnotfound", e.getMessage()));
                            }
                            if (this.useErasurator()) {
                                c = erasurator.erasure(c);
                            }
                            if ((t = PluginAPI.BEFORE_WRITE.getTransformer()) != null) {
                                try {
                                    c = t.transform(c);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                            }
                            if ((f = PluginAPI.BEFORE_WRITE.getFilter()) != null && !f.accept(c)) continue;
                            writer.write(c);
                        }
                    }
                    catch (Throwable throwable) {
                        iterator = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fos != null) {
                            if (iterator != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)((Object)iterator)).addSuppressed(throwable);
                                }
                            } else {
                                fos.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object2 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                if (bo.isSet(Option.DEBUG)) {
                    SwissKnife.reportThrowable(e);
                }
                this.getLog().println(i18n.getString("Setup.error.message.cantcreatesigfile"));
                this.getLog().println(e);
                boolean bl = this.error(i18n.getString("Setup.error.message.cantcreatesigfile"));
                if (cp != null) {
                    if (object != null) {
                        try {
                            cp.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        cp.close();
                    }
                }
                return bl;
            }
        }
        catch (Throwable testableLoader) {
            object = testableLoader;
            throw testableLoader;
        }
        finally {
            if (cp != null) {
                if (object != null) {
                    try {
                        cp.close();
                    }
                    catch (Throwable testableLoader) {
                        ((Throwable)object).addSuppressed(testableLoader);
                    }
                } else {
                    cp.close();
                }
            }
        }
        this.printErrors();
        this.getLog().println(i18n.getString("Setup.report.message.selectedbypackageclasses", Integer.toString(this.includedClassesNumber + this.excludedClassesNumber)));
        if (!this.excludedPackages.isEmpty() || !this.apiExcl.isEmpty()) {
            this.getLog().println(i18n.getString("Setup.report.message.excludedbypackageclasses", Integer.toString(this.excludedClassesNumber)));
        }
        if (this.isClosedFile && !excludedClasses.isEmpty()) {
            boolean printHeader = true;
            for (String clsName : excludedClasses) {
                String[] subClasses = this.testableHierarchy.getDirectSubclasses(clsName);
                if (subClasses.length <= 0) continue;
                int count = 0;
                for (String subClass : subClasses) {
                    if (excludedClasses.contains(subClass)) continue;
                    if (count != 0) {
                        this.getLog().print(", ");
                    } else {
                        if (printHeader) {
                            this.getLog().println(i18n.getString("Setup.log.message.exclude_warning_header"));
                            printHeader = false;
                        }
                        this.getLog().println(i18n.getString("Setup.log.message.exclude_warning", clsName));
                    }
                    this.getLog().print(subClass);
                    ++count;
                }
                this.getLog().println();
            }
        }
        this.getLog().print(i18n.getString("Setup.report.message.outerclasses", Integer.toString(this.outerClassesNumber)));
        if (this.innerClassesNumber != 0) {
            this.getLog().println(i18n.getString("Setup.report.message.innerclasses", Integer.toString(this.innerClassesNumber)));
        } else {
            this.getLog().println();
        }
        if (this.errors == 0) {
            return this.passed(this.outerClassesNumber == 0 ? i18n.getString("Setup.report.message.emptysigfile") : "");
        }
        if (!this.keepSigFile) {
            new File(sigFile.getFile()).delete();
        }
        return this.failed(i18n.getString("Setup.report.message.numerrors", Integer.toString(this.errors)));
    }

    private void removeUndocumentedAnnotations(ClassDescription c, ClassHierarchy classHierarchy) {
        c.setAnnoList(this.removeUndocumentedAnnotations(c.getAnnoList(), classHierarchy));
        Iterator<MemberDescription> e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = e.next();
            mr.setAnnoList(this.removeUndocumentedAnnotations(mr.getAnnoList(), classHierarchy));
        }
    }

    private Collection<String> getPackageClasses(Collection<String> classes) {
        HashSet<String> packageClasses = new HashSet<String>();
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        int nonTigerCount = 0;
        for (String name : classes) {
            if (this.isPackageMember(name)) {
                ++this.includedClassesNumber;
                try {
                    ClassDescription c = this.testableHierarchy.load(name);
                    if (this.testableHierarchy.isAccessible(c)) {
                        packageClasses.add(name);
                        if (c.isTiger()) continue;
                        ++nonTigerCount;
                        if (!Xverbose || !isTigerFeaturesTracked) continue;
                        this.getLog().println(i18n.getString("Setup.report.message.nontigerclass", name));
                        continue;
                    }
                    this.ignore(i18n.getString("Setup.report.ignore.protect", name));
                }
                catch (ClassNotFoundException ex) {
                    if (bo.isSet(Option.DEBUG)) {
                        SwissKnife.reportThrowable(ex);
                    }
                    this.setupProblem(i18n.getString("Setup.error.message.classnotfound", name));
                }
                catch (LinkageError ex1) {
                    if (bo.isSet(Option.DEBUG)) {
                        SwissKnife.reportThrowable(ex1);
                    }
                    this.setupProblem(i18n.getString("Setup.error.message.classnotlinked", ex1.getMessage()));
                }
                continue;
            }
            if (!this.excludedPackages.isEmpty() && this.excludedPackages.checkName(name)) {
                ++this.excludedClassesNumber;
            } else if (!this.apiExcl.isEmpty() && this.apiExcl.checkName(name)) {
                ++this.excludedClassesNumber;
            }
            this.ignore(i18n.getString("Setup.report.ignore.notreqpackage", name));
        }
        return packageClasses;
    }

    private List<String> sortClasses(Collection<String> classes) {
        ArrayList<String> retVal = new ArrayList<String>(classes);
        Collections.sort(retVal);
        return retVal;
    }

    protected void ignore(String message) {
        if (this.isVerbose) {
            this.getLog().println(message);
        }
    }
}

