/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.specifictypes;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.MappingTester;
import com.sun.ts.tests.jsonb.SimpleMappingTester;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.BigDecimalContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.BigIntegerContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.OptionalArrayContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.OptionalContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.OptionalDoubleContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.OptionalIntContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.OptionalLongContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.OptionalTypeContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.SimpleContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.URIContainer;
import com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model.URLContainer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;

public class SpecificTypesMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        SpecificTypesMappingTest t = new SpecificTypesMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testBigIntegerMapping() throws EETest.Fault {
        return new MappingTester<BigInteger>(BigIntegerContainer.class).test(new BigInteger("0"), "0");
    }

    public Status testBigDecimalMapping() throws EETest.Fault {
        return new MappingTester<BigDecimal>(BigDecimalContainer.class).test(new BigDecimal("0.0"), "0.0");
    }

    public Status testURLMapping() throws Exception {
        return new MappingTester<URL>(URLContainer.class).test(new URL("http://www.host.com:80"), "\"http://www.host.com:80\"");
    }

    public Status testURIMapping() throws Exception {
        return new MappingTester<URI>(URIContainer.class).test(new URI("http://www.host.com:80"), "\"http://www.host.com:80\"");
    }

    public Status testOptionalMapping() throws EETest.Fault {
        return new MappingTester<Optional<String>>(OptionalContainer.class).test(Optional.of("String Value"), "\"String Value\"");
    }

    public Status testOptionalObjectMapping() throws EETest.Fault {
        OptionalTypeContainer container = new OptionalTypeContainer();
        SimpleContainer simpleContainer = new SimpleContainer();
        simpleContainer.setStringInstance("String Value");
        container.setInstance(Optional.of(simpleContainer));
        return new SimpleMappingTester<OptionalTypeContainer>(OptionalTypeContainer.class).test(container, "\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"stringInstance\"\\s*:\\s*\"String Value\"\\s*}\\s*}", "{ \"instance\" : { \"stringInstance\" : \"String Value\" } }", container);
    }

    public Status testEmptyOptionalMapping() throws EETest.Fault {
        OptionalContainer optionalContainer = new OptionalContainer();
        optionalContainer.setInstance(Optional.empty());
        return new SimpleMappingTester<OptionalContainer>(OptionalContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }

    public Status testEmptyOptionalArrayMapping() throws EETest.Fault {
        OptionalArrayContainer optionalContainer = new OptionalArrayContainer();
        optionalContainer.setInstance(new Optional[]{Optional.empty()});
        return new SimpleMappingTester<OptionalArrayContainer>(OptionalArrayContainer.class).test(optionalContainer, "\\{\\s*\"instance\"\\s*:\\s*\\[\\s*null\\s*]\\s*}", "{ \"instance\" : [ null ] }", optionalContainer);
    }

    public Status testOptionalIntMapping() throws EETest.Fault {
        return new MappingTester<OptionalInt>(OptionalIntContainer.class).test(OptionalInt.of(0), "0");
    }

    public Status testEmptyOptionalIntMapping() throws EETest.Fault {
        OptionalIntContainer optionalContainer = new OptionalIntContainer();
        optionalContainer.setInstance(OptionalInt.empty());
        return new SimpleMappingTester<OptionalIntContainer>(OptionalIntContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }

    public Status testOptionalLongMapping() throws EETest.Fault {
        return new MappingTester<OptionalLong>(OptionalLongContainer.class).test(OptionalLong.of(0L), "0");
    }

    public Status testEmptyOptionalLongMapping() throws EETest.Fault {
        OptionalLongContainer optionalContainer = new OptionalLongContainer();
        optionalContainer.setInstance(OptionalLong.empty());
        return new SimpleMappingTester<OptionalLongContainer>(OptionalLongContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }

    public Status testOptionalDoubleMapping() throws EETest.Fault {
        return new MappingTester<OptionalDouble>(OptionalDoubleContainer.class).test(OptionalDouble.of(0.0), "0.0");
    }

    public Status testEmptyOptionalDoubleMapping() throws EETest.Fault {
        OptionalDoubleContainer optionalContainer = new OptionalDoubleContainer();
        optionalContainer.setInstance(OptionalDouble.empty());
        return new SimpleMappingTester<OptionalDoubleContainer>(OptionalDoubleContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }
}

