/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import jakarta.ejb.Timer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class MethodDispatcher {
    public static final String TIMEOUT_PREFIX = "timeOut_";
    public static final String ONMESSAGE_PREFIX = "onMessage_";

    protected MethodDispatcher() {
    }

    public static void dispatchTimeOut(Timer timer, Object target, QueueConnectionFactory qfactory, Queue queue) {
        TimerInfo ti = (TimerInfo)timer.getInfo();
        String testname = ti.getTestName();
        if (testname == null) {
            throw new IllegalStateException("testname is null in timer info: " + ti);
        }
        String methodName = TIMEOUT_PREFIX + testname;
        Method method = null;
        Throwable exception = null;
        boolean testResult = false;
        String reason = null;
        try {
            method = target.getClass().getMethod(methodName, Timer.class, TimerInfo.class);
            method.invoke(target, timer, ti);
        }
        catch (SecurityException ex) {
            exception = ex;
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (InvocationTargetException ex) {
            exception = ex.getTargetException();
        }
        if (exception == null) {
            testResult = true;
            reason = "TimeOut in " + target;
        } else {
            testResult = false;
            reason = TestUtil.printStackTraceToString((Throwable)exception);
        }
        StatusReporter.report(testname, testResult, reason, qfactory, queue);
    }

    public static void dispatchOnMessage(Message msg, Object target, String testname) {
        if (testname == null) {
            throw new IllegalStateException("testname is null when trying to dispatch to " + target);
        }
        String methodName = ONMESSAGE_PREFIX + testname;
        Method method = null;
        Throwable exception = null;
        try {
            method = target.getClass().getMethod(methodName, Message.class);
            method.invoke(target, msg);
        }
        catch (SecurityException ex) {
            exception = ex;
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (InvocationTargetException ex) {
            exception = ex.getTargetException();
        }
        if (exception != null) {
            throw new IllegalStateException(exception);
        }
    }
}

