/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.method.sec.style2;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.method.sec.style2.TestBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.method.sec.style2.TestBeanHome;
import java.rmi.RemoteException;
import java.util.Properties;

public class Client
extends EETest {
    private static final String prefix = "java:comp/env/ejb/";
    private static final String beanLookup = "java:comp/env/ejb/TestBean";
    private static final String userPropName = "user";
    private static final String pwdPropName = "password";
    private TSNamingContext nctx = null;
    private Properties props = null;
    private String user;
    private String password;
    private TestBeanHome beanHome;
    private TestBean bean;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            this.props = props;
            TestUtil.logTrace((String)"[Client] Getting TS Naming Context...");
            this.nctx = new TSNamingContext();
            TestUtil.logTrace((String)"[Client] Getting user/password info...");
            this.user = props.getProperty(userPropName);
            this.password = props.getProperty(pwdPropName);
            TestUtil.logTrace((String)("[Client] Log in as " + this.user + " / " + this.password));
            TSLoginContext lc = new TSLoginContext();
            lc.login(this.user, this.password);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[Client] Caught exception: " + e));
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testStyle2Positive() throws EETest.Fault {
        try {
            this.bean = null;
            TestUtil.logTrace((String)"[Client] Looking up java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(beanLookup, TestBeanHome.class);
            this.bean = this.beanHome.create(this.props, 1, "capuccino", 11.0f);
            TestUtil.logTrace((String)"[Client] Calling test1()...");
            boolean pass = this.bean.test1();
            if (!pass) {
                throw new EETest.Fault("Style 2 positive test failed.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[Client] Unexpected exception: " + e));
            throw new EETest.Fault("Style 2 positive test failed: ", e);
        }
        finally {
            try {
                if (null != this.bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    this.bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e));
            }
        }
    }

    public void testStyle2Negative() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"[Client] Looking up java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(beanLookup, TestBeanHome.class);
            this.bean = this.beanHome.create(this.props, 2, "mocha", 11.0f);
            TestUtil.logTrace((String)"[Client] Calling test2()...");
            boolean pass = this.bean.test2();
            throw new EETest.Fault("Style2 negative test failed: We were allowed to call method!");
        }
        catch (RemoteException e) {
            TestUtil.logTrace((String)"[Client] Caught java.rmi.RemoteException as expected");
            try {
                if (null != this.bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    this.bean.remove();
                }
            }
            catch (Exception e2) {
                TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e2));
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("[Client] Unexpected exception: " + e));
                throw new EETest.Fault("Style2 negative test failed: ", e);
            }
            catch (Throwable throwable) {
                try {
                    if (null != this.bean) {
                        TestUtil.logTrace((String)"[Client] Removing bean...");
                        this.bean.remove();
                    }
                }
                catch (Exception e3) {
                    TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e3));
                }
                throw throwable;
            }
        }
    }

    public void testStyle3Style2() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"[Client] Looking up java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(beanLookup, TestBeanHome.class);
            this.bean = this.beanHome.create(this.props, 3, "expresso", 11.0f);
            TestUtil.logTrace((String)"[Client] Calling test2(int)...");
            boolean pass = this.bean.test1(1789);
            if (!pass) {
                throw new EETest.Fault("Style 3 union test failed.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[Client] Unexpected exception: " + e));
            throw new EETest.Fault("Style3 union test failed: ", e);
        }
        finally {
            try {
                if (null != this.bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    this.bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e));
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

