/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.bmp.common;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.bmp.util.DBSupport;
import jakarta.ejb.CreateException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import java.sql.SQLException;
import java.util.Properties;

public class SecTestEJB
implements EntityBean {
    private EntityContext ectx = null;
    private float cofPrice = 0.0f;
    private static final String user1 = "user1";
    private static final String password1 = "password1";
    private String ctsuser = null;
    private String ctspassword = null;

    public void SecTestEJB() throws CreateException {
        TestUtil.logTrace((String)"In constructor!");
    }

    public Integer ejbCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        DBSupport db = null;
        try {
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"Initialize DBSupport");
            db = new DBSupport(this.ectx);
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            db.getDBConnection(this.ctsuser, this.ctspassword);
            if (newTable) {
                db.tableInit();
            }
            db.createNewRow(cofID, cofName, cofPrice);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (SQLException se) {
            TestUtil.logErr((String)"SQL Exception in create: ", (Throwable)se);
            throw new CreateException("SQL Exception in create" + se.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Unable to initialize DBSupport");
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
        return new Integer(cofID);
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        DBSupport db = null;
        try {
            TestUtil.logMsg((String)"Initialize DBSupport");
            db = new DBSupport(this.ectx);
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            db.getDBConnection(this.ctsuser, this.ctspassword);
            db.removeRow((Integer)this.ectx.getPrimaryKey());
        }
        catch (SQLException se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new RemoveException("SQL Exception in remove");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoveException("Unable to initialize DBSupport");
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        DBSupport db = null;
        try {
            TestUtil.logMsg((String)"Initialize DBSupport");
            db = new DBSupport(this.ectx);
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            TestUtil.logMsg((String)"Get DB Connection");
            db.getDBConnection(this.ctsuser, this.ctspassword);
            boolean foundKey = db.keyExists(key);
            if (foundKey) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Unable to obtain naming context");
            }
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        DBSupport db = null;
        try {
            TestUtil.logMsg((String)"Initialize DBSupport");
            db = new DBSupport(this.ectx);
            TestUtil.logMsg((String)"Get DB Connection");
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            db.getDBConnection(this.ctsuser, this.ctspassword);
            boolean foundKey = db.keyExists(key);
            if (foundKey) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Unable to obtain naming context");
            }
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void ejbPostCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"In ejbPostCreate !!");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void setEntityContext(EntityContext x) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = x;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean IsCaller(String caller) {
        return this.ectx.getCallerPrincipal().getName().indexOf(caller) >= 0;
    }

    public boolean EjbNotAuthz() {
        return true;
    }

    public boolean EjbIsAuthz() {
        return true;
    }

    public boolean EjbSecRoleRef(String role) {
        return this.ectx.isCallerInRole(role);
    }

    public boolean EjbOverloadedSecRoleRefs(String role1) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ") = " + this.ectx.isCallerInRole(role1)));
        return this.ectx.isCallerInRole(role1);
    }

    public boolean EjbOverloadedSecRoleRefs(String role1, String role2) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ")= " + this.ectx.isCallerInRole(role1) + "isCallerInRole(" + role2 + ")= " + this.ectx.isCallerInRole(role2)));
        return this.ectx.isCallerInRole(role1) && this.ectx.isCallerInRole(role2);
    }

    public boolean checktest1() {
        return true;
    }

    public boolean excludetest1() {
        return true;
    }
}

