/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.clientviewtest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.NoSuchEntityException;
import jakarta.ejb.RemoveException;
import java.util.Collection;
import java.util.Properties;
import javax.naming.NamingException;

public class TestBeanEJB
implements EntityBean {
    private CoffeeBean cache;
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;
    private float cofPrice;
    private CoffeeDAO dao = null;

    public Integer ejbCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            TestUtil.logTrace((String)"DAO: Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cache = new CoffeeBean(cofID, cofName, cofPrice);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"Obtaining TS Naming Context...");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("Naming Exception : " + e));
            throw new EJBException("Cannot obtain Naming Context" + e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EJBException("Caught exception: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Remove row...");
            this.dao.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            throw new RemoveException("Caught DAOException" + e);
        }
        catch (Exception e) {
            throw new RemoveException("Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Load row...");
            this.cache = this.dao.load((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.logErr((String)("No such entity exists: " + e));
            throw new NoSuchEntityException("[ejbload] DAOException" + e);
        }
        catch (Exception e) {
            throw new EJBException("[ejbload] Unable to init DAO " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Store row...");
            this.dao.store(this.cache);
        }
        catch (DAOException de) {
            TestUtil.logErr((String)("No such entity: " + de));
            throw new NoSuchEntityException("[ejbStore] DAOException" + de);
        }
        catch (Exception e) {
            throw new EJBException("[ejbStore] Unable to init DAO");
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
            this.dao = null;
        }
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Collection ejbFindByName(Properties p, String name) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByName");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            Collection c = this.dao.nameToKeyCollection(name);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Name not found: " + name);
            }
            catch (DAOException de) {
                TestUtil.printStackTrace((Throwable)de);
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Collection ejbFindByPrice(Properties p, float price) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrice");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            Collection c = this.dao.priceToKeyCollection(price);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Price not found: " + price);
            }
            catch (DAOException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("DAOException in price finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Collection ejbFindWithinPriceRange(Properties p, float pmin, float pmax) throws FinderException {
        TestUtil.logTrace((String)"ejbFindWithinPriceRange");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            Collection c = this.dao.priceRangeToCollection(pmin, pmax);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Price Range not found: [" + pmin + "-" + pmax + "]");
            }
            catch (DAOException de) {
                TestUtil.printStackTrace((Throwable)de);
                throw new FinderException("DAOException in price range finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Collection ejbFindWithinPrimaryKeyRange(Properties p, Integer kmin, Integer kmax) throws FinderException {
        TestUtil.logTrace((String)"ejbFindWithinPrimaryKeyRange");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            Collection c = this.dao.primaryKeyRangeToCollection(kmin, kmax);
            if (c.size() > 0) {
                Collection collection = c;
                return collection;
            }
            try {
                throw new FinderException("Primary Key Range not found: [" + kmin + "-" + kmax + "]");
            }
            catch (DAOException de) {
                TestUtil.printStackTrace((Throwable)de);
                throw new FinderException("DAOException in primary key range finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public String ping(String s) {
        TestUtil.logTrace((String)("ping : " + s));
        return "ping: " + s;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

