/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.bm.allowedmethodstest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.bm.allowedmethodstest.Helper;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.cm.allowedmethodstest.TimerLocal;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.cm.allowedmethodstest.TimerLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerHandle;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.UserTransaction;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;

public class TestBeanEJB
implements SessionBean {
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private TSNamingContext nctx = null;
    private Helper helperRef = null;
    private TimerHandle th;
    private String role = "Administrator";
    private Hashtable table = new Hashtable();
    private static final String testLookup = "java:comp/env/ejb/Helper";
    private static final String timerLookup = "java:comp/env/ejb/TimerLocal";
    private UserTransaction ut;
    private static final String[] tests = new String[]{"ejbCreate", "ejbRemove", "ejbActivate", "ejbPassivate", "setSessionContext", "businessMethod"};
    private static final Properties[] methodList = new Properties[]{new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties()};

    public void ejbCreate(Properties p, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"get Timer Handle via doTimer");
            this.th = this.doTimer();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (NamingException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        if (flag == 0) {
            this.doOperationTests("ejbCreate");
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to obtain NamingContext");
        }
        this.doOperationTests("setSessionContext");
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
        this.doOperationTests("ejbRemove");
        try {
            if (this.helperRef != null) {
                this.helperRef.setData(this.table);
            }
        }
        catch (RemoteException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new EJBException(re.getMessage());
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
        this.doOperationTests("ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
        this.doOperationTests("ejbPassivate");
    }

    public Hashtable getResults() {
        TestUtil.logTrace((String)"getResults");
        return this.table;
    }

    public void businessMethod() {
        TestUtil.logTrace((String)"businessMethod");
        this.doOperationTests("businessMethod");
    }

    public void setHelper(Helper ref) {
        TestUtil.logTrace((String)"setHelper");
        this.helperRef = ref;
    }

    private int testIndex(String s) {
        TestUtil.logTrace((String)"testIndex");
        for (int i = 0; i < tests.length; ++i) {
            if (!s.equals(tests[i])) continue;
            return i;
        }
        return -1;
    }

    private void setTestList(int i) {
        TestUtil.logTrace((String)"setTestList");
        methodList[i].setProperty("JNDI_Access", "true");
        methodList[i].setProperty("getEJBHome", "true");
        methodList[i].setProperty("getCallerPrincipal", "true");
        methodList[i].setProperty("getRollbackOnly", "true");
        methodList[i].setProperty("isCallerInRole", "true");
        methodList[i].setProperty("setRollbackOnly", "true");
        methodList[i].setProperty("getEJBObject", "true");
        methodList[i].setProperty("UserTransaction", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test1", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test2", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test3", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test4", "true");
        methodList[i].setProperty("getEJBLocalHome", "true");
        methodList[i].setProperty("getEJBLocalObject", "true");
        methodList[i].setProperty("Timer_Methods", "true");
    }

    private void doOperationTests(String s) {
        TestUtil.logTrace((String)"doOperationTests");
        int i = this.testIndex(s);
        TestUtil.logMsg((String)("index for " + s + " is " + i));
        TestUtil.logMsg((String)("methodList length=" + methodList.length));
        TestUtil.logMsg((String)("tests length=" + tests.length));
        this.setTestList(i);
        TestUtil.logMsg((String)("Operations testing for " + s + " method ..."));
        try {
            this.sctx.getEJBHome();
            TestUtil.logMsg((String)"Operations test: getEJBHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getCallerPrincipal();
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getCallerPrincipal", "false");
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getCallerPrincipal", "unexpected");
            TestUtil.logMsg((String)("Operations test: getCallerPrincipal() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getRollbackOnly();
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getRollbackOnly", "unexpected");
            TestUtil.logMsg((String)("Operations test: getRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.isCallerInRole(this.role);
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("isCallerInRole", "false");
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("isCallerInRole", "unexpected");
            TestUtil.logMsg((String)("Operations test: isCallerInRole() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBObject();
            TestUtil.logMsg((String)"Operations test: getEJBObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            Context ctx = (Context)this.nctx.lookup("java:comp/env");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("JNDI_Access", "false");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("JNDI_Access", "unexpected");
            TestUtil.logMsg((String)("Operations test: JNDI_Access - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ut = this.sctx.getUserTransaction();
            TestUtil.logMsg((String)"Operations test: UserTransaction - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().begin();
            TestUtil.logMsg((String)"Operations test: UserTransaction.begin - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test1", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.begin - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test1", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.begin - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().commit();
            TestUtil.logMsg((String)"Operations test: UserTransaction.commit - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test2", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.commit - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test2", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.commit - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().getStatus();
            TestUtil.logMsg((String)"Operations test: UserTransaction.getStatus - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test3", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.getStatus - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test3", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.getStatus - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().setTransactionTimeout(5);
            TestUtil.logMsg((String)"Operations test: UserTransaction.setTransactionTimeout - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test4", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.setTransactionTimeout - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test4", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.setTransactionTimeout - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.setRollbackOnly();
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("setRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("setRollbackOnly", "unexpected");
            TestUtil.logMsg((String)("Operations test: setRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBLocalHome();
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBLocalObject();
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            if (this.th != null) {
                Timer t = this.th.getTimer();
                TestUtil.logMsg((String)"Got timer");
                this.th = t.getHandle();
                TestUtil.logMsg((String)"Got timer handle");
                long tRemaining = t.getTimeRemaining();
                TestUtil.logMsg((String)("Time remaining is " + tRemaining));
                Date tNextTimeout = t.getNextTimeout();
                TestUtil.logMsg((String)("Next timeout is " + tNextTimeout));
                String tInfo = (String)((Object)t.getInfo());
                TestUtil.logMsg((String)("Timer info is " + tInfo));
                TestUtil.logMsg((String)"Operations test: Timer_Methods() - allowed");
            } else {
                TestUtil.logMsg((String)"Variable th is null - not set in setSessionContext");
                methodList[i].setProperty("Timer_Methods", "false");
            }
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("Timer_Methods", "false");
            TestUtil.logMsg((String)"Operations test: Timer_Methods() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("Timer_Methods", "unexpected");
            TestUtil.logMsg((String)("Operations test: Timer_Methods() - not allowed (Unexpected Exception) - " + e));
        }
        this.table.put(s, methodList[i]);
    }

    public void stopTestTimer() {
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            TSNamingContext nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Looking up home interface for stateless bean creating timer: java:comp/env/ejb/TimerLocal");
            TimerLocalHome timerHome = (TimerLocalHome)nctx.lookup(timerLookup);
            TimerLocal timerRef = timerHome.create();
            timerRef.findAndCancelTimer();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("stopTestTimer:" + e);
        }
    }

    private TimerHandle doTimer() {
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            TSNamingContext nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Looking up home interface for stateless bean creating timer: java:comp/env/ejb/TimerLocal");
            TimerLocalHome timerHome = (TimerLocalHome)nctx.lookup(timerLookup);
            TimerLocal timerRef = timerHome.create();
            return timerRef.startTimer(60000L, "info");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("startTimer:" + e);
        }
    }

    public boolean testUTBegin() {
        boolean pass = false;
        try {
            this.sctx.getUserTransaction().begin();
            TestUtil.logMsg((String)"UserTransaction.begin - allowed");
            TestUtil.logTrace((String)"Attempt to call begin again before commit() or rollback()");
            this.sctx.getUserTransaction().begin();
            TestUtil.logMsg((String)"UserTransaction.begin - allowed");
        }
        catch (NotSupportedException nse) {
            pass = true;
            TestUtil.logMsg((String)"NotSupportedException caught as expected");
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Unexpected Exception - " + e));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (this.sctx.getUserTransaction().getStatus() != 6) {
                    TestUtil.logTrace((String)"Rollback the active TX from the first begin call");
                    this.sctx.getUserTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logMsg((String)("Exception caught on ut.rollback() - " + re));
            }
        }
        return pass;
    }
}

