/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

abstract class TimeoutEvent
implements Comparable<TimeoutEvent> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final long id = COUNTER.incrementAndGet();
    private final Instant deadline;

    TimeoutEvent(Duration duration) {
        this.deadline = Instant.now().plus(duration);
    }

    public abstract void handle();

    public Instant deadline() {
        return this.deadline;
    }

    @Override
    public int compareTo(TimeoutEvent timeoutEvent) {
        if (timeoutEvent == this) {
            return 0;
        }
        int n = this.deadline.compareTo(timeoutEvent.deadline);
        if (n == 0 && !this.equals(timeoutEvent)) {
            long l = this.id - timeoutEvent.id;
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            assert (false) : "Different events with same id and deadline";
        }
        return n;
    }

    public String toString() {
        return "TimeoutEvent[id=" + this.id + ", deadline=" + this.deadline + "]";
    }
}

