/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmscontextqueuetests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmscontextqueuetests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSContext contextToSendMsg = null;
    private transient JMSProducer producer = null;
    private transient JMSConsumer consumer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    String vehicle = null;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            TestUtil.logMsg((String)("JMSVersion=" + tmp2));
            if (!tmp2.equals("3.0")) {
                TestUtil.logErr((String)("Error: incorrect JMSVersion=" + tmp2));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            TestUtil.logMsg((String)("JMSMajorVersion=" + tmp3));
            if (tmp3 != 3) {
                TestUtil.logErr((String)("Error: incorrect JMSMajorVersion=" + tmp3));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            TestUtil.logMsg((String)("JMSMinorVersion=" + tmp4));
            if (tmp4 != 0) {
                TestUtil.logErr((String)("Error: incorrect JMSMinorVersion=" + tmp4));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            TestUtil.logMsg((String)("JMSProviderName=" + tmp));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            TestUtil.logMsg((String)("JMSProviderVersion=" + tmp));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            TestUtil.logMsg((String)("ProviderMajorVersion=" + tmp5));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            TestUtil.logMsg((String)("ProviderMinorVersion=" + tmp6));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        this.logMsg("Results: " + status[index]);
        return retcode;
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.vehicle = p.getProperty("vehicle");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.tool.getDefaultConnection().close();
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.producer = this.contextToSendMsg.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
            }
            this.context = null;
            if (this.contextToSendMsg != null) {
                this.contextToSendMsg.close();
            }
            this.contextToSendMsg = null;
            this.producer = null;
            TestUtil.logMsg((String)"Flush any messages left on Queue");
            this.tool.flushDestination();
            TestUtil.logMsg((String)"Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.consumer = null;
            this.tool.closeAllResources();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
        if (!pass) {
            throw new EETest.Fault("cleanup failed!");
        }
    }

    public void createTemporayQueueTest() throws EETest.Fault {
        boolean pass = true;
        try {
            String sendMessage = "a text message";
            TestUtil.logMsg((String)"Creating TemporaryQueue");
            TemporaryQueue tempQueue = this.context.createTemporaryQueue();
            TestUtil.logMsg((String)"Create JMSConsumer");
            JMSConsumer smc = this.context.createConsumer((Destination)tempQueue);
            TestUtil.logMsg((String)"Send message to temporaty queue using JMSProducer");
            this.producer.send((Destination)tempQueue, sendMessage);
            TestUtil.logMsg((String)"Receive message from temporaty queue");
            String recvMessage = (String)smc.receiveBody(String.class, this.timeout);
            TestUtil.logMsg((String)"Checking received message");
            if (recvMessage == null) {
                throw new EETest.Fault("Did not receive Message");
            }
            if (!recvMessage.equals(sendMessage)) {
                TestUtil.logErr((String)("Unexpected message: received " + recvMessage + " , expected " + sendMessage));
                pass = false;
            } else {
                TestUtil.logMsg((String)("received correct message: " + recvMessage + " as expected"));
            }
            TestUtil.logMsg((String)"Attempting to delete temporary queue with an open consumer should not be allowed");
            try {
                tempQueue.delete();
                pass = false;
                TestUtil.logErr((String)"TemporaryQueue.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                TestUtil.logMsg((String)"Received expected JMSException: ");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Close JMSConsumer");
            smc.close();
            TestUtil.logMsg((String)"Attempting to delete temporary queue with no open consumer should be allowed");
            try {
                tempQueue.delete();
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("createTemporayQueueTest");
        }
        if (!pass) {
            throw new EETest.Fault("createTemporayQueueTest failed");
        }
    }

    public void createQueueBrowserTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TextMessage tempMsg = null;
            QueueBrowser qBrowser = null;
            Enumeration msgs = null;
            this.consumer.close();
            this.consumer = null;
            TestUtil.logMsg((String)"Send 3 messages to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createQueueBrowserTest" + i);
                String tmp = null;
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                    tmp = "with boolean property lastMessage=true";
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                    tmp = "with boolean property lastMessage=false";
                }
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent " + tmp));
            }
            TestUtil.logMsg((String)"Create QueueBrowser to peek at last message in Queue using message selector (lastMessage = TRUE)");
            qBrowser = this.context.createBrowser(this.queue, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Check that browser has just the last message");
            int msgCount = 0;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                TestUtil.logMsg((String)("Text=" + tempMsg.getText() + ", lastMessage=" + tempMsg.getBooleanProperty("lastMessage")));
                if (!tempMsg.getText().equals("Message 3")) {
                    TestUtil.logErr((String)("Found [" + tempMsg.getText() + "] in browser expected only [Message 3]"));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Found [Message 3] in browser");
                }
                ++msgCount;
            }
            if (msgCount != 1) {
                TestUtil.logErr((String)("Found " + msgCount + " messages in browser expected 1"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Found 1 message in browser (correct)");
            }
            qBrowser.close();
            TestUtil.logMsg((String)"Create QueueBrowser to browse all messages in the Queue");
            qBrowser = this.context.createBrowser(this.queue);
            TestUtil.logMsg((String)"Check that browser contains all 3 messages");
            msgCount = 0;
            int msgIndex = 1;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                if (!tempMsg.getText().equals("Message " + msgIndex)) {
                    TestUtil.logErr((String)("Found [" + tempMsg.getText() + "] in browser expected [Message " + msgIndex + "]"));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("Found [Message " + msgIndex + "] in browser (correct)"));
                }
                ++msgCount;
                ++msgIndex;
            }
            if (msgCount != 3) {
                TestUtil.logErr((String)("Found " + msgCount + " messages in browser expected " + 3));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Found 3 messages in browser (correct)");
            }
            qBrowser.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("createQueueBrowserTest");
        }
        if (!pass) {
            throw new EETest.Fault("createQueueBrowserTest failed");
        }
    }

    public void createConsumerTest() throws EETest.Fault {
        boolean pass = true;
        JMSConsumer consumerSelect = null;
        try {
            TextMessage tempMsg = null;
            Object msgs = null;
            this.consumer.close();
            this.consumer = null;
            TestUtil.logMsg((String)"Create selective JMSConsumer with selector [\"lastMessage=TRUE\"]");
            consumerSelect = this.context.createConsumer(this.destination, "lastMessage=TRUE");
            TestUtil.logMsg((String)"Send 3 messages to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                String tmp = null;
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                    tmp = "with boolean property lastMessage=true";
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                    tmp = "with boolean property lastMessage=false";
                }
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent " + tmp));
            }
            TestUtil.logMsg((String)"Receive last message with selective JMSConsumer and boolean property (lastMessage=TRUE)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                TestUtil.logErr((String)"Message 3 missing from Queue");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + 3 + "]"));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Try receiving one more message (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("JMSConsumer.receive() returned a message [" + tempMsg.getText() + "]"));
                TestUtil.logErr((String)"JMSConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Received no message (CORRECT)");
            }
            TestUtil.logMsg((String)"Close selective JMSConsumer");
            consumerSelect.close();
            consumerSelect = null;
            TestUtil.logMsg((String)"Create normal JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Receive rest of messages with normal JMSConsumer");
            for (int msgCount = 1; msgCount < 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Queue"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Try receiving one more message (should get none)");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("JMSConsumer returned message " + tempMsg.getText() + " (expected None)"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Received no message (CORRECT)");
            }
            TestUtil.logMsg((String)"Close normal JMSConsumer");
            this.consumer.close();
            this.consumer = null;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("createConsumerTest");
        }
        finally {
            try {
                if (consumerSelect != null) {
                    consumerSelect.close();
                }
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createConsumerTest failed");
        }
    }

    public void getMetaDataTest() throws EETest.Fault {
        boolean pass = true;
        ConnectionMetaData data = null;
        try {
            data = this.context.getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getMetaDataTest failed");
        }
    }

    public void getSessionModeTest() throws EETest.Fault {
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password);
            int expSessionMode = 1;
            TestUtil.logMsg((String)("Calling getSessionMode and expect " + expSessionMode + " to be returned"));
            int actSessionMode = context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                TestUtil.logErr((String)("getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getSessionModeTest");
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        int[] expSessionMode = new int[]{0, 1, 2, 3};
        for (int i = 0; i < expSessionMode.length; ++i) {
            if (!(!this.vehicle.equals("ejb") && !this.vehicle.equals("jsp") && !this.vehicle.equals("servlet") || expSessionMode[i] != 0 && expSessionMode[i] != 2)) continue;
            try {
                TestUtil.logMsg((String)("Creating context with session mode (" + expSessionMode[i] + ")"));
                context = this.cf.createContext(this.user, this.password, expSessionMode[i]);
                TestUtil.logMsg((String)("Calling getSessionMode and expect " + expSessionMode[i] + " to be returned"));
                int actSessionMode = context.getSessionMode();
                if (actSessionMode == expSessionMode[i]) continue;
                TestUtil.logErr((String)("getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode[i]));
                pass = false;
                continue;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getSessionModeTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("getSessionModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTransactedTest() throws EETest.Fault {
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password, 1);
            TestUtil.logMsg((String)"Calling getTransacted and expect false to be returned");
            boolean transacted = context.getTransacted();
            if (transacted) {
                TestUtil.logErr((String)"getTransacted() returned true expected false");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                context = this.cf.createContext(this.user, this.password, 0);
                TestUtil.logMsg((String)"Calling getTransacted and expect true to be returned");
                boolean transacted = context.getTransacted();
                if (!transacted) {
                    TestUtil.logErr((String)"getTransacted() returned false expected true");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getTransactedTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("getTransactedTest failed");
        }
    }

    public void getClientIDTest() throws EETest.Fault {
        boolean pass = true;
        try {
            String cid = this.context.getClientID();
            TestUtil.logErr((String)("getClientID() returned " + cid + ", expected clientid"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getClientIDTest");
        }
        if (!pass) {
            throw new EETest.Fault("getClientIDTest failed");
        }
    }

    public void setGetAutoStartTest() throws EETest.Fault {
        boolean actAutoStart;
        boolean expAutoStart;
        boolean pass = true;
        try {
            expAutoStart = true;
            TestUtil.logMsg((String)("Calling getAutoStart and expect " + expAutoStart + " to be returned"));
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                TestUtil.logErr((String)("getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        try {
            expAutoStart = false;
            TestUtil.logMsg((String)("Calling setAutoStart(" + expAutoStart + ")"));
            this.context.setAutoStart(expAutoStart);
            TestUtil.logMsg((String)("Calling getAutoStart and expect " + expAutoStart + " to be returned"));
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                TestUtil.logErr((String)("getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("setGetAutoStartTest");
        }
        if (!pass) {
            throw new EETest.Fault("setGetAutoStartTest failed");
        }
    }

    public void multipleCloseContextTest() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Call close on JMSContext created in setup.");
            this.context.close();
            TestUtil.logMsg((String)"Call close on a JMSContext a second time");
            this.context.close();
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("multipleCloseContextTest");
        }
    }

    public void invalidDestinationRuntimeExceptionTests() throws EETest.Fault {
        boolean pass = true;
        Destination invalidDestination = null;
        Queue invalidQueue = null;
        String message = "Where are you!";
        byte[] bytesMsgSend = message.getBytes();
        HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
        mapMsgSend.put("StringValue", "sendAndRecvTest7");
        mapMsgSend.put("BooleanValue", true);
        mapMsgSend.put("IntValue", 10);
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, Message) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)expTextMessage);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, message);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Serializable) for InvalidDestinationRuntimeException");
            TestUtil.logMsg((String)"Send ObjectMessage");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage om = this.context.createObjectMessage();
            StringBuffer sb = new StringBuffer(message);
            om.setObject((Serializable)sb);
            om.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, Serializable) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)om);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, byte[]) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, byte[]) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, bytesMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Map) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, Map) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, mapMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createBrowser(Queue, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createBrowser(Queue, String) -> expect InvalidDestinationRuntimeException");
                this.context.createBrowser(invalidQueue, "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createBrowser(Queue) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createBrowser(Queue) -> expect InvalidDestinationRuntimeException");
                this.context.createBrowser(invalidQueue);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("invalidDestinationRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidDestinationRuntimeExceptionTests failed");
        }
    }

    public void invalidSelectorRuntimeExceptionTests() throws EETest.Fault {
        boolean pass = true;
        String invalidMessageSelector = "=TEST 'test'";
        try {
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer(this.destination, invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer(this.destination, invalidMessageSelector, false);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createBrowser(Queue, String) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createBrowser(Queue, String) -> expect InvalidSelectorRuntimeException");
                this.context.createBrowser(this.queue, invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException, as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException,, received " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("invalidSelectorRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidSelectorRuntimeExceptionTests failed");
        }
    }

    public void illegalStateRuntimeExceptionTest() throws EETest.Fault {
        boolean pass;
        block15: {
            pass = true;
            String message = "Where are you!";
            try {
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                TestUtil.logMsg((String)"Sending message to the Queue");
                TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                try {
                    TestUtil.logMsg((String)"JMSContext.commit() on non-transacted session must throw IllegalStateRuntimeException");
                    this.context.commit();
                    pass = false;
                    TestUtil.logErr((String)"Error: JMSContext.commit() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.commit()");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                TestUtil.logMsg((String)"Sending message to the Queue");
                TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                try {
                    TestUtil.logMsg((String)"JMSContext.rollback() on non-transacted session must throw IllegalStateRuntimeException");
                    this.context.rollback();
                    pass = false;
                    TestUtil.logErr((String)"Error: JMSContext.rollback() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.rollback()");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
                if (!this.vehicle.equals("appclient") && !this.vehicle.equals("standalone")) break block15;
                JMSContext contextTX = this.cf.createContext(this.user, this.password, 0);
                JMSProducer producerTX = contextTX.createProducer();
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = contextTX.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                TestUtil.logMsg((String)"Sending message to the Queue");
                TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
                producerTX.send(this.destination, (Message)expTextMessage);
                try {
                    TestUtil.logMsg((String)"JMSContext.recover() on a transacted session must throw IllegalStateRuntimeException");
                    contextTX.recover();
                    pass = false;
                    TestUtil.logErr((String)"Error: JMSContext.recover() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.recover()");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
                contextTX.close();
                try {
                    TestUtil.logMsg((String)"Create JMSContext with CLIENT_ACKNOWLEDGE");
                    JMSContext msgcontext = this.cf.createContext(this.user, this.password, 2);
                    TestUtil.logMsg((String)"Close JMSContext");
                    msgcontext.close();
                    TestUtil.logMsg((String)"Call JMSContext.acknowledge() on a closed session which is illegal");
                    msgcontext.acknowledge();
                    TestUtil.logErr((String)"Didn't throw IllegalStateRuntimeException");
                    pass = false;
                }
                catch (IllegalStateRuntimeException e) {
                    this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.acknowledge()");
                }
                catch (Exception e) {
                    TestUtil.logMsg((String)("Caught expected exception" + e));
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("illegalStateRuntimeExceptionTest");
            }
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateRuntimeExceptionTest");
        }
    }
}

