/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.visibility;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.visibility.model.CustomFieldVisibilityStrategy;
import com.sun.ts.tests.jsonb.customizedmapping.visibility.model.CustomVisibilityAnnotatedContainer;
import com.sun.ts.tests.jsonb.customizedmapping.visibility.model.SimpleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.visibility.model.customized.PackageCustomizedContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import java.util.Properties;

public class VisibilityCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        VisibilityCustomizationTest t = new VisibilityCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testCustomVisibilityConfig() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withPropertyVisibilityStrategy((PropertyVisibilityStrategy)new CustomFieldVisibilityStrategy()));
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"floatInstance\"\\s*:\\s*0.0\\s*}")) {
            throw new EETest.Fault("Failed to hide fields during marshalling by applying custom visibility strategy using configuration.");
        }
        SimpleContainer unmarshalledObject = (SimpleContainer)jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"floatInstance\" : 1.0, \"integerInstance\" : 1 }", SimpleContainer.class);
        if (unmarshalledObject.getStringInstance() != null || unmarshalledObject.getIntegerInstance() != 1 || unmarshalledObject.getFloatInstance() != 1.0f) {
            throw new EETest.Fault("Failed to ignore fields during unmarshalling by applying custom visibility strategy using configuration.");
        }
        return Status.passed((String)"OK");
    }

    public Status testCustomVisibilityAnnotation() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new CustomVisibilityAnnotatedContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"floatInstance\"\\s*:\\s*0.0\\s*}")) {
            throw new EETest.Fault("Failed to hide fields during marshalling by applying custom visibility strategy using JsonbVisibility annotation.");
        }
        CustomVisibilityAnnotatedContainer unmarshalledObject = (CustomVisibilityAnnotatedContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"floatInstance\" : 1.0, \"integerInstance\" : 1 }", CustomVisibilityAnnotatedContainer.class);
        if (unmarshalledObject.getStringInstance() != null || unmarshalledObject.getIntegerInstance() != null || unmarshalledObject.getFloatInstance() != 0.0f) {
            throw new EETest.Fault("Failed to ignore fields during unmarshalling by applying custom visibility strategy using JsonbVisibility annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testCustomVisibilityPackage() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"floatInstance\"\\s*:\\s*0.0\\s*}")) {
            throw new EETest.Fault("Failed to hide fields during marshalling by applying custom visibility strategy using JsonbVisibility annotation on package.");
        }
        PackageCustomizedContainer unmarshalledObject = (PackageCustomizedContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"floatInstance\" : 1.0, \"integerInstance\" : 1 }", PackageCustomizedContainer.class);
        if (unmarshalledObject.getStringInstance() != null || unmarshalledObject.getIntegerInstance() != null || unmarshalledObject.getFloatInstance() != 0.0f) {
            throw new EETest.Fault("Failed to ignore fields during unmarshalling by applying custom visibility strategy using JsonbVisibility annotation on package.");
        }
        return Status.passed((String)"OK");
    }
}

