/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejbembed;

import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.ejbembed.InjectionResolver;
import com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteClientIF;
import com.sun.ts.tests.common.vehicle.ejbliteshare.ReasonableStatus;
import jakarta.ejb.embeddable.EJBContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;

public class EJBEmbedRunner
implements VehicleRunnable {
    private static final Logger logger = Logger.getLogger("com.sun.ts.tests.common.vehicle.ejbembed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run(String[] args, Properties props) {
        int statusCode = 3;
        String passOrFail = null;
        String reason = null;
        EJBLiteClientIF client = null;
        try {
            client = this.createClient(args, props);
            passOrFail = client.getStatus();
            reason = client.getReason();
            statusCode = passOrFail.startsWith("[TEST PASSED] ") ? 0 : 1;
        }
        catch (Exception e) {
            statusCode = 1;
            reason = TestUtil.printStackTraceToString((Throwable)e);
        }
        finally {
            if (client != null) {
                client.getContainer().close();
            }
        }
        return new ReasonableStatus(statusCode, reason);
    }

    private File[] parseAdditionalModules(String[] args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> mods = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!"-additionalModule".equals(args[i])) continue;
            mods.add(args[++i]);
        }
        File[] files = new File[mods.size()];
        for (int i = 0; i < mods.size(); ++i) {
            files[i] = new File((String)mods.get(i));
        }
        return files;
    }

    private EJBLiteClientIF createClient(String[] args, Properties props) throws Exception {
        Class<?> c = Class.forName(props.getProperty("test_classname"));
        EJBLiteClientIF client = (EJBLiteClientIF)c.newInstance();
        client.setAdditionalModules(this.parseAdditionalModules(args));
        client.setTestName(props.getProperty("testName"));
        client.setInjectionSupported(false);
        client.setModuleName("ejbembed_vehicle_ejb");
        client.setContextClassLoader();
        Map<String, Object> containerInitProps = client.getContainerInitProperties();
        EJBContainer container = containerInitProps == null ? EJBContainer.createEJBContainer() : EJBContainer.createEJBContainer(containerInitProps);
        Context context = container.getContext();
        client.setContainer(container);
        client.setContext(context);
        InjectionResolver injectionResolver = new InjectionResolver(client, container);
        injectionResolver.resolve();
        return client;
    }
}

