/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.TimeoutStatusBean;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBContext;
import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TimerBeanBaseWithoutTimeOutMethod {
    @Resource
    protected EJBContext ejbContext;
    @Resource
    protected TimerService timerService;
    @EJB
    protected TimeoutStatusBean statusSingleton;

    protected void timeout(Timer timer) {
        this.timeoutAlias(timer);
    }

    protected void timeoutAlias(Timer timer) {
        ScheduleExpression exp = timer.isCalendarTimer() ? timer.getSchedule() : null;
        Serializable ser = timer.getInfo();
        String testName = null;
        if (ser instanceof TimerInfo) {
            testName = ((TimerInfo)ser).getTestName();
        } else if (ser instanceof String) {
            testName = (String)((Object)ser);
        } else {
            throw new RuntimeException("Unrecognizable type for timer info: " + ser);
        }
        String timeoutRecord = "Invoking Timeout method for timer with schedule: " + TimerUtil.toString(exp) + ", info: " + ser + ", and isPersistent: " + timer.isPersistent();
        Helper.getLogger().fine(timeoutRecord);
        this.statusSingleton.addRecord(testName, timeoutRecord);
        this.statusSingleton.setStatus(testName, true);
    }

    public Collection<Timer> getTimers() {
        return this.timerService.getTimers();
    }

    public Collection<Timer> getAllTimers() {
        return this.timerService.getAllTimers();
    }

    public void cancelTimer(Timer ... timers) {
        for (Timer timer : timers) {
            timer.cancel();
        }
    }

    public void cancelAllTimers() {
        TimerUtil.cancelAllTimers(this.timerService, false);
    }

    public Timer createTimer(ScheduleExpression exp, String name) {
        return this.createTimer(exp, new TimerInfo(name));
    }

    public boolean isPersistent(Timer timer) {
        return timer.isPersistent();
    }

    public boolean isCalendarTimer(Timer timer) {
        return timer.isCalendarTimer();
    }

    public ScheduleExpression getSchedule(Timer timer) {
        return timer.isCalendarTimer() ? timer.getSchedule() : null;
    }

    public Timer createTimer(Date expiration, TimerConfig timerConfig) {
        return this.timerService.createSingleActionTimer(expiration, timerConfig);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) {
        return this.timerService.createIntervalTimer(initialExpiration, intervalDuration, timerConfig);
    }

    public Timer createTimer(long duration, TimerConfig timerConfig) {
        return this.timerService.createSingleActionTimer(duration, timerConfig);
    }

    public Timer createTimer(long InitialDuration, long intervalDuration, TimerConfig timerConfig) {
        return this.timerService.createIntervalTimer(InitialDuration, intervalDuration, timerConfig);
    }

    public Timer createTimer(ScheduleExpression exp, TimerConfig timerConfig) {
        return this.timerService.createCalendarTimer(exp, timerConfig);
    }

    public Timer createTimer(ScheduleExpression exp, TimerInfo info) {
        return this.timerService.createCalendarTimer(exp, new TimerConfig((Serializable)info, true));
    }

    public Timer createTimer(long duration, Serializable timerInfo) {
        return this.timerService.createTimer(duration, timerInfo);
    }

    public Timer createTimer(Date expiration, long duration, Serializable timerInfo) {
        return this.timerService.createTimer(expiration, duration, timerInfo);
    }

    public Timer createFarFutureTimer(String name) {
        return TimerUtil.createFarFutureTimer(this.timerService, name);
    }

    public Timer createFarFutureTimer(TimerConfig timerConfig) {
        return TimerUtil.createFarFutureTimer(this.timerService, timerConfig);
    }

    public Timer createSecondLaterTimer(String name) {
        return TimerUtil.createSecondLaterTimer(this.timerService, name);
    }

    public Timer createSecondLaterTimer(String name, int seconds) {
        return TimerUtil.createSecondLaterTimer(this.timerService, name, seconds);
    }

    public Timer createSecondLaterTimer(TimerConfig timerConfig) {
        return TimerUtil.createSecondLaterTimer(this.timerService, timerConfig);
    }

    public Timer createSecondLaterTimer(TimerConfig timerConfig, int seconds) {
        return TimerUtil.createSecondLaterTimer(this.timerService, timerConfig, seconds);
    }

    public Timer createMillisecondLaterTimer(String name) {
        return TimerUtil.createMillisecondLaterTimer(this.timerService, name);
    }

    public Timer createMillisecondLaterTimer(String name, boolean persistent) {
        return TimerUtil.createMillisecondLaterTimer(this.timerService, name, persistent);
    }

    public Timer findTimer(TimerInfo info) {
        return TimerUtil.findTimer(this.timerService, info);
    }

    public long getTimeRemaining(Timer timer) {
        return timer.getTimeRemaining();
    }

    public Date getNextTimeout(Timer timer) {
        return timer.getNextTimeout();
    }

    public Timer findTimer(String info) {
        return TimerUtil.findTimer(this.timerService, info);
    }

    public Timer findTimer(TimerConfig timerConfig) {
        return TimerUtil.findTimer(this.timerService, timerConfig);
    }

    public String passIfNoMoreTimeouts(Timer t) {
        String result = "";
        try {
            Date nextTimeout = t.getNextTimeout();
            throw new RuntimeException("Expecting NoSuchObjectLocalException or NoMoreTimeoutsException when accessing getNextTimeout, but actual " + nextTimeout);
        }
        catch (NoMoreTimeoutsException e) {
            result = result + " Got expected " + (Object)((Object)e);
        }
        catch (NoSuchObjectLocalException e) {
            result = result + " Got expected " + (Object)((Object)e);
        }
        try {
            long timeRemaining = t.getTimeRemaining();
            throw new RuntimeException("Expecting NoSuchObjectLocalException or NoMoreTimeoutsException when accessing getTimeRemaining, but actual " + timeRemaining);
        }
        catch (NoMoreTimeoutsException e) {
            result = result + " Got expected " + (Object)((Object)e);
        }
        catch (NoSuchObjectLocalException e) {
            result = result + " Got expected " + (Object)((Object)e);
        }
        return result;
    }

    public String passIfNoSuchObjectLocalException(Timer t) {
        List<String> expected = Arrays.asList("getInfo", "isCalendarTimer", "getHandle", "getNextTimeout", "getSchedule", "getTimeRemaining", "isPersistent", "cancel");
        ArrayList<String> calls = new ArrayList<String>();
        try {
            Serializable info = t.getInfo();
            Helper.getLogger().warning("getInfo on an expired timer returned " + info);
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("getInfo");
        }
        try {
            t.isCalendarTimer();
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("isCalendarTimer");
        }
        try {
            t.getHandle();
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("getHandle");
        }
        catch (IllegalStateException e) {
            calls.add("getHandle");
        }
        try {
            t.getNextTimeout();
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("getNextTimeout");
        }
        try {
            t.getSchedule();
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("getSchedule");
        }
        catch (IllegalStateException e) {
            calls.add("getSchedule");
        }
        try {
            t.getTimeRemaining();
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("getTimeRemaining");
        }
        try {
            t.isPersistent();
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("isPersistent");
        }
        try {
            t.cancel();
        }
        catch (NoSuchObjectLocalException e) {
            calls.add("cancel");
        }
        if (expected.equals(calls)) {
            return "Got expected NoSuchObjectLocalException for timer methods:" + expected.toString();
        }
        throw new RuntimeException("Expecting NoSuchObjectLocalException for timer methods:" + expected.toString() + ", but actual " + ((Object)calls).toString());
    }
}

