/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.NativeFunctionPrefixResolver;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.XPathResult;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeFunction;
import org.apache.xml.utils.PrefixResolver;

@JsxClass(browsers={@WebBrowser(value=BrowserName.FF, minVersion=17.0f)})
public class XPathEvaluator
extends SimpleScriptable {
    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public XPathResult evaluate(String expression, Object contextNodeObj, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)result;
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
        }
        Node contextNode = null;
        if (!(contextNodeObj instanceof Node)) {
            throw Context.reportRuntimeError((String)"Illegal value for parameter 'context'");
        }
        contextNode = (Node)contextNodeObj;
        PrefixResolver prefixResolver = null;
        if (resolver instanceof PrefixResolver) {
            prefixResolver = (PrefixResolver)resolver;
        } else if (resolver instanceof NativeFunction) {
            prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, contextNode.getParentScope());
        }
        xPathResult.init(((DomNode)contextNode.getDomNodeOrDie()).getByXPath(expression, prefixResolver), type);
        return xPathResult;
    }
}

