/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;

public class Client2
extends Util {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupAliasData")
    public void selectIllegalArgumentException() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            this.logTrace("Creating select using selection items with the same alias");
            try {
                CompoundSelection c = cbuilder.array(new Selection[]{customer.get("id").alias("SAMEALIAS"), customer.get("name").alias("SAMEALIAS")});
                cquery.select((Selection)c);
                this.logErr("Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        }
        if (!pass) {
            throw new Exception("selectIllegalArgumentException failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void multiselectIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.logMsg("Testing multiselect invalid item");
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            this.logTrace("Creating multiselect using selection array of items that do not exist");
            try {
                cquery.multiselect(new Selection[]{customer.get("doesnotexist").alias("ALIAS1"), customer.get("doesnotexist2").alias("ALIAS2")});
                this.logErr("Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        }
        this.logMsg("Testing multiselect selection[]");
        cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            this.logTrace("Creating multiselect using selection array of items with the same alias");
            Selection[] selection = new Selection[]{customer.get("id").alias("SAMEALIAS"), customer.get("name").alias("SAMEALIAS")};
            try {
                cquery.multiselect(selection);
                this.logErr("Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        }
        this.logMsg("Testing multiselect List");
        cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            this.logTrace("Creating multiselect using selection items with the same alias");
            try {
                ArrayList<Selection> list = new ArrayList<Selection>();
                list.add(customer.get("id").alias("SAMEALIAS"));
                list.add(customer.get("name").alias("SAMEALIAS"));
                cquery.multiselect(list);
                this.logErr("Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("received expected IllegalArgumentException");
                pass3 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("multiselectIllegalArgumentExceptionTest failed");
        }
    }
}

