/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.concurrency.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.common.ConcurrencyIF;

public class ClientBase
extends EJBLiteClientBase {
    protected final int NUM_OF_THREADS = 100;
    protected final int NUM_OF_ADDITIONS = 10000;
    protected final int NUM_TO_ADD = 999;
    protected final long CORRECT_SUM = 999000000L;
    protected static final String[] INTERCEPTORS = new String[]{"Interceptor0", "Interceptor3"};
    protected ConcurrencyIF singleton;
    protected ConcurrencyIF singleton2;

    public void lockedSum1() {
        this.lockedSum(this.singleton);
    }

    public void lockedSum2() {
        this.lockedSum(this.singleton2);
    }

    public void lockedSumFromInterceptors1() {
        this.lockedSumFromInterceptors(this.singleton);
    }

    public void lockedSumFromInterceptors2() {
        this.lockedSumFromInterceptors(this.singleton2);
    }

    public void lockedLinkedList1() {
        this.lockedLinkedList(this.singleton);
    }

    public void lockedLinkedList2() {
        this.lockedLinkedList(this.singleton2);
    }

    protected void unlockedSum(ConcurrencyIF b) {
        this.concurrentWrites(b, "addUnlocked", null);
        long actual = b.getAndResetUnlockedSum();
        this.assertNotEquals("Compare CORRECT_SUM 999000000, and actual " + actual, 999000000L, actual);
    }

    protected void unlockedSumFromInterceptors(ConcurrencyIF b) {
        for (String inter : INTERCEPTORS) {
            this.concurrentWrites(b, "addUnlockedFromInterceptor", inter);
            long actual = b.getAndResetUnlockedSumFromInterceptor(inter);
            this.assertNotEquals("Compare CORRECT_SUM 999000000, and actual " + actual, 999000000L, actual);
        }
    }

    protected void lockedSum(ConcurrencyIF b) {
        this.concurrentWrites(b, "addLocked", null);
        this.assertEquals(null, 999000000L, b.getAndResetLockedSum());
    }

    protected void lockedSumFromInterceptors(ConcurrencyIF b) {
        for (String inter : INTERCEPTORS) {
            this.concurrentWrites(b, "addLockedFromInterceptor", inter);
            long actual = b.getAndResetLockedSumFromInterceptor(inter);
            this.assertEquals(null, 999000000L, actual);
        }
    }

    protected void lockedLinkedList(ConcurrencyIF b) {
        this.concurrentWrites(b, "addToLinkedList", null);
        this.assertEquals(null, 1000000, b.getLinkedListSizeAndClear());
    }

    protected void concurrentWrites(final ConcurrencyIF b, final String methodName, final String interceptorName) {
        int i;
        Thread[] threads = new Thread[100];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10000; ++i) {
                        if ("addLocked".equals(methodName)) {
                            b.addLocked(999);
                            continue;
                        }
                        if ("addUnlocked".equals(methodName)) {
                            b.addUnlocked(999);
                            continue;
                        }
                        if ("addToLinkedList".equals(methodName)) {
                            b.addToLinkedList(999);
                            continue;
                        }
                        if ("addLockedFromInterceptor".equals(methodName)) {
                            b.addLockedFromInterceptor(interceptorName, 999);
                            continue;
                        }
                        if (!"addUnlockedFromInterceptor".equals(methodName)) continue;
                        b.addUnlockedFromInterceptor(interceptorName, 999);
                    }
                }
            });
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                TestUtil.logErr((String)"Exception caught during concurrentWrites", (Throwable)e);
            }
        }
    }
}

