/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient.validation;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.Goldenfile;
import com.sun.ts.tests.common.webclient.Util;
import com.sun.ts.tests.common.webclient.validation.WebValidatorBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class TokenizedValidator
extends WebValidatorBase {
    private static final String RECORD_GF = "ts.record.gf";

    @Override
    protected boolean checkGoldenfile() throws IOException {
        String gf = null;
        String path = this._case.getGoldenfilePath();
        String enc = this._res.getResponseEncoding();
        if (path == null) {
            return true;
        }
        Goldenfile file = new Goldenfile(this._case.getGoldenfilePath(), enc);
        try {
            File goldenFile = new File(this._case.getGoldenfilePath());
            if (goldenFile.exists()) {
                gf = file.getGoldenFileAsString();
            } else if (this._case.getGoldenfileStream() != null) {
                gf = Util.getEncodedStringFromStream(this._case.getGoldenfileStream(), enc);
            }
        }
        catch (IOException ioe) {
            TestUtil.logErr("[TokenizedValidator] Unexpected exception while accessing goldenfile! " + ioe.toString());
            return false;
        }
        String response = this._res.getResponseBodyAsString();
        StringTokenizer gfTokenizer = new StringTokenizer(gf);
        StringTokenizer resTokenizer = new StringTokenizer(response);
        int gfCount = gfTokenizer.countTokens();
        int resCount = resTokenizer.countTokens();
        if (gf.equals("NO GOLDENFILE FOUND") && Boolean.getBoolean(RECORD_GF)) {
            TestUtil.logTrace("[TokenizedValidator][INFO] RECORDING GOLDENFILE: " + path);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path), enc);
            out.write(response);
            out.flush();
            out.close();
        }
        if (gfCount == resCount) {
            while (gfTokenizer.hasMoreTokens()) {
                String res;
                String exp = gfTokenizer.nextToken();
                if (exp.equals(res = resTokenizer.nextToken())) continue;
                StringBuffer sb = new StringBuffer(255);
                sb.append("[TokenizedValidator]: Server's response and ");
                sb.append("goldenfile to not match!\n");
                sb.append("\n            Goldenfile token: ").append(exp);
                sb.append("\n            Response token:   ").append(res);
                TestUtil.logErr(sb.toString());
                TokenizedValidator.dumpResponseInfo(response, gf);
                return false;
            }
        } else {
            TestUtil.logErr("[TokenizedValidator]: Token count between server response and goldenfile do not match.\n Response Tokencount: " + resCount + "\nGoldenfile Token count: " + gfCount);
            TokenizedValidator.dumpResponseInfo(response, gf);
            return false;
        }
        TestUtil.logTrace("[TokenizedValidator]: Server's response matches the configured goldenfile.");
        return true;
    }

    private static void dumpResponseInfo(String serverResponse, String goldenFile) {
        StringBuffer sb = new StringBuffer(255);
        sb.append("\nServer Response (below):\n");
        sb.append("------------------------------------------\n");
        sb.append(serverResponse);
        sb.append("\n------------------------------------------\n");
        sb.append("\nGoldenfile (below):\n");
        sb.append("------------------------------------------\n");
        sb.append(goldenFile);
        sb.append("\n------------------------------------------\n");
        TestUtil.logErr(sb.toString());
    }
}

