/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.pmservlet;

import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManager;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManagerFactory;
import com.sun.ts.tests.common.vehicle.ejb3share.UserTransactionWrapper;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContexts;
import jakarta.persistence.PersistenceUnit;
import jakarta.transaction.UserTransaction;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@PersistenceContexts(value={@PersistenceContext(name="persistence/CTS-EM", unitName="CTS-EM"), @PersistenceContext(name="persistence/CTS-EM2", unitName="CTS-EM2")})
public class PMServletVehicle
extends ServletVehicle {
    private static final String EM_LOOKUP_NAME = "java:comp/env/persistence/CTS-EM";
    private UserTransaction ut;
    @PersistenceUnit(unitName="CTS-EM")
    EntityManagerFactory emf;

    public EntityTransaction getEntityTransaction() {
        try {
            TSNamingContext nctx = new TSNamingContext();
            this.ut = (UserTransaction)nctx.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            TestUtil.logMsg("Naming service exception: " + e.getMessage());
            e.printStackTrace();
        }
        return new UserTransactionWrapper(this.ut);
    }

    private Object lookup(String lookupName) throws IllegalStateException {
        Object result = null;
        try {
            InitialContext context = new InitialContext();
            result = context.lookup(lookupName);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to lookup:" + lookupName, e);
        }
        return result;
    }

    @Override
    protected RemoteStatus runTest() {
        this.properties.put("persistence.unit.name", "CTS-EM");
        RemoteStatus sTestStatus = new RemoteStatus(Status.passed(""));
        try {
            if (this.testObj instanceof UseEntityManager) {
                EntityManager em = (EntityManager)this.lookup(EM_LOOKUP_NAME);
                if (em == null) {
                    throw new IllegalStateException("EntityManager is null");
                }
                UseEntityManager client2 = (UseEntityManager)((Object)this.testObj);
                EntityTransaction et = this.getEntityTransaction();
                client2.setEntityManager(em);
                client2.setEntityTransaction(et);
                client2.setInContainer(true);
            }
            if (this.testObj instanceof UseEntityManagerFactory) {
                if (this.emf == null) {
                    throw new IllegalStateException("EntityManagerFactory is null");
                }
                UseEntityManagerFactory client2 = (UseEntityManagerFactory)((Object)this.testObj);
                client2.setEntityManagerFactory(this.emf);
            }
            if ((sTestStatus = new RemoteStatus(this.testObj.run(this.arguments, this.properties))).getType() == 0) {
                System.out.println("Test running in pmservlet vehicle passed");
            } else {
                System.out.println("Test running in pmservlet vehicle failed");
            }
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Test running in pmservlet vehicle failed: ");
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
            sTestStatus = new RemoteStatus(Status.failed(sb.toString()));
            TestUtil.logErr("Test running in pmservlet vehicle failed", e);
        }
        return sTestStatus;
    }
}

