/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedQueueConnection;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedQueueConnectionTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.appclient.closedQueueConnection.ClosedQueueConnectionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueConnectionTests theTests = new ClosedQueueConnectionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseConnection(int type) throws Exception {
        if (type == 0 || type == 2) {
            this.tool = new JmsTool(type, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Closing queue Connection");
            this.tool.getDefaultQueueConnection().close();
        }
        this.logTrace("Connection closed");
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'users' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedQueueConnectionSetClientIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setClientID");
            try {
                this.tool.getDefaultQueueConnection().setClientID("foo");
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetClientIDTest", e);
        }
    }

    public void closedQueueConnectionSetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setExceptionListener");
            try {
                ExceptionListener foo = new ExceptionListener(){

                    public void onException(JMSException jmsE) {
                    }
                };
                this.tool.getDefaultQueueConnection().setExceptionListener(foo);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetExceptionListenerTest", e);
        }
    }

    public void closedQueueConnectionGetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getMessageListener");
            try {
                MessageListener foo = this.tool.getDefaultQueueReceiver().getMessageListener();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetMessageListenerTest", e);
        }
    }

    public void closedQueueConnectionSetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                this.tool.getDefaultQueueReceiver().setMessageListener(foo);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetMessageListenerTest", e);
        }
    }

    public void closedQueueConnectionGetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getExceptionListener");
            try {
                ExceptionListener foo = this.tool.getDefaultQueueConnection().getExceptionListener();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetExceptionListenerTest", e);
        }
    }

    public void closedQueueConnectionStopTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call stop");
            try {
                this.tool.getDefaultQueueConnection().stop();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionStopTest", e);
        }
    }

    public void closedQueueConnectionAckTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            QueueSession qSession = null;
            QueueReceiver qReceiver = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            TestUtil.logTrace((String)"Creating new session");
            qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            qSender = qSession.createSender(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Creating 1 TextMessage");
            messageSent = qSession.createTextMessage();
            messageSent.setText("Message from closedQueueConnectionAckTest");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "closedQueueConnectionAckTest");
            TestUtil.logMsg((String)"Sending a TextMessage");
            qSender.send((Message)messageSent);
            TestUtil.logMsg((String)"Receiving TextMessage");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            TestUtil.logMsg((String)"Closing DefaultQueueConnection");
            qReceiver.close();
            qSender.close();
            qSession.close();
            this.tool.getDefaultQueueConnection().close();
            try {
                if (messageReceived == null) {
                    pass = false;
                    TestUtil.logErr((String)"Didnot receive any message!!");
                } else {
                    messageReceived.acknowledge();
                    pass = false;
                    TestUtil.logErr((String)"Should not be here!");
                }
            }
            catch (IllegalStateException is) {
                TestUtil.logMsg((String)"Pass: IllegalStateException thrown by acknowledge as expected");
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Expected IllegalStateException, got", (Throwable)e);
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueConnectionAckTest");
        }
    }
}

