/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.ordercolumn;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Course;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Student;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Client1
extends PMClientBase {
    private List<Student> expectedResults;

    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createStudentTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void orderColumn() throws Exception {
        boolean pass = false;
        String expectedStudentName = "Joseph";
        int expectedListSize = 4;
        int courseNumber = 101;
        int numStudents = 0;
        try {
            this.getEntityTransaction().begin();
            Course course = (Course)this.getEntityManager().find(Course.class, (Object)101);
            if (course != null) {
                numStudents = course.getStudents().size();
            } else {
                this.logErr("course from find() is NULL!");
            }
            if (numStudents == 4) {
                List<Student> students = course.getStudents();
                if (students.get(0).equals(this.expectedResults.get(0)) && students.get(1).equals(this.expectedResults.get(1)) && students.get(2).equals(this.expectedResults.get(2)) && students.get(3).equals(this.expectedResults.get(3))) {
                    this.logTrace("****Current order of students returned via getStudents()\nNow checking via JPQL");
                    Query q = this.getEntityManager().createQuery("SELECT s.studentName FROM Course c JOIN c.students s where c.courseName ='Physics' and INDEX(s) = 1");
                    String result = (String)q.getSingleResult();
                    if (result.equals("Joseph")) {
                        this.logTrace("+++Received expected Name via Query:Joseph");
                        pass = true;
                    } else {
                        this.logErr("Did NOT get expected name via Query: Joseph, received: " + result);
                    }
                } else {
                    this.logErr("Failed to return the correct order of students via getStudents()");
                }
            } else {
                this.logErr("course.getStudents() returned wrong number!");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
        }
        if (!pass) {
            throw new Exception("orderColumn test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStudentTestData() {
        try {
            this.logTrace("createTestData");
            this.getEntityTransaction().begin();
            Student student1 = new Student(1, "Neo");
            Student student2 = new Student(2, "Vivek");
            Student student3 = new Student(3, "Arun");
            Student student4 = new Student(4, "Ganesh");
            Student student5 = new Student(5, "Ram");
            Student student6 = new Student(6, "Rahim");
            Student student7 = new Student(7, "Joseph");
            Student student8 = new Student(8, "Krishna");
            Course appliedMath = new Course(101, "AppliedMathematics");
            Course physics = new Course(102, "Physics");
            Course operationResearch = new Course(103, "OperationResearch");
            Course statistics = new Course(201, "Statistics");
            Course operatingSystem = new Course(202, "OperatingSystem");
            ArrayList<Student> studentList1 = new ArrayList<Student>();
            studentList1.add(student1);
            studentList1.add(student7);
            studentList1.add(student2);
            studentList1.add(student8);
            this.expectedResults = new ArrayList<Student>();
            this.expectedResults.addAll(studentList1);
            ArrayList<Student> studentList2 = new ArrayList<Student>();
            studentList2.add(student3);
            studentList2.add(student4);
            ArrayList<Student> studentList3 = new ArrayList<Student>();
            studentList3.add(student5);
            studentList3.add(student6);
            ArrayList<Student> studentList4 = new ArrayList<Student>();
            studentList4.add(student7);
            studentList4.add(student8);
            appliedMath.setStudents(studentList1);
            physics.setStudents(studentList1);
            operationResearch.setStudents(studentList1);
            statistics.setStudents(studentList2);
            operatingSystem.setStudents(studentList2);
            ArrayList<Course> firstSemCourses = new ArrayList<Course>();
            firstSemCourses.add(appliedMath);
            firstSemCourses.add(physics);
            firstSemCourses.add(operationResearch);
            ArrayList<Course> secondSemCourses = new ArrayList<Course>();
            secondSemCourses.add(statistics);
            secondSemCourses.add(operatingSystem);
            student1.setCourses(firstSemCourses);
            student2.setCourses(firstSemCourses);
            student3.setCourses(secondSemCourses);
            student4.setCourses(secondSemCourses);
            student5.setCourses(secondSemCourses);
            student6.setCourses(secondSemCourses);
            student7.setCourses(firstSemCourses);
            student8.setCourses(firstSemCourses);
            EntityManager entityManager = this.getEntityManager();
            entityManager.persist((Object)student1);
            entityManager.persist((Object)student2);
            entityManager.persist((Object)student3);
            entityManager.persist((Object)student4);
            entityManager.persist((Object)student5);
            entityManager.persist((Object)student6);
            entityManager.persist((Object)student7);
            entityManager.persist((Object)student8);
            this.logTrace("persisted 8 students");
            entityManager.persist((Object)appliedMath);
            entityManager.persist((Object)physics);
            entityManager.persist((Object)operationResearch);
            entityManager.persist((Object)statistics);
            entityManager.persist((Object)operatingSystem);
            this.logTrace("persisted 5 Courses");
            this.logTrace("persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COURSE_STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COURSE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

