/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.lambda;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "lambda_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="lambda_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"lambda_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientServletTest.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logMsg((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprBigDecimalTest() throws Exception {
        String comparitorA = "BigDecimal";
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            this.runLambdaExpressions("+", BigDecimal.valueOf(2L), comparitorA, bValue, bName);
            this.runLambdaExpressions("-", BigDecimal.valueOf(0L), comparitorA, bValue, bName);
            this.runLambdaExpressions("*", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0.0, comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprFloatTest() throws Exception {
        String comparitorA = "Float";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logMsg((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            if ("BigInteger".equals(bName)) {
                this.runLambdaExpressions("+", BigDecimal.valueOf(2L), comparitorA, bValue, bName);
                this.runLambdaExpressions("-", BigDecimal.valueOf(0L), comparitorA, bValue, bName);
                this.runLambdaExpressions("*", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            } else {
                this.runLambdaExpressions("+", 2.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("-", 0.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("*", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            }
            this.runLambdaExpressions("%", 0.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0.0, comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprDoubleTest() throws Exception {
        String comparitorA = "Double";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logMsg((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            if ("BigInteger".equals(bName)) {
                this.runLambdaExpressions("+", BigDecimal.valueOf(2L), comparitorA, bValue, bName);
                this.runLambdaExpressions("-", BigDecimal.valueOf(0L), comparitorA, bValue, bName);
                this.runLambdaExpressions("*", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            } else {
                this.runLambdaExpressions("+", 2.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("-", 0.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("*", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            }
            this.runLambdaExpressions("%", 0.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0.0, comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprBigIntegerTest() throws Exception {
        String comparitorA = "BigInteger";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Double");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logMsg((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            this.runLambdaExpressions("+", BigInteger.valueOf(2L), comparitorA, bValue, bName);
            this.runLambdaExpressions("-", BigInteger.valueOf(0L), comparitorA, bValue, bName);
            this.runLambdaExpressions("*", BigInteger.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("%", BigInteger.valueOf(0L), comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", BigInteger.valueOf(0L), comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprIntegerTest() throws Exception {
        String comparitorA = "Integer";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Double");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logMsg((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprLongTest() throws Exception {
        String comparitorA = "Long";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logMsg((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprShortTest() throws Exception {
        String comparitorA = "Short";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logMsg((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprByteTest() throws Exception {
        String comparitorA = "Byte";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        excludeList.add("Short");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logMsg((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprStringTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String aValue = "a='Testing'";
        String bValue = "b='Testing'";
        elp.eval(aValue);
        elp.eval(bValue);
        Validator.testExpression(elp, "(((x, y)-> x += y)(a, b))", "TestingTesting", "'Testing' += 'Testing'");
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elLambdaExprNullTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        elp.defineBean("types", (Object)new TypesBean());
        Long expected = 0L;
        String aValue = "a = types.tckNull";
        String bValue = "b = types.tckNull";
        elp.eval(aValue);
        elp.eval(bValue);
        String operator = "+";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null + null");
        operator = "-";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null - null");
        operator = "*";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null * null");
        operator = "/";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null / null");
        operator = "div";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null div null");
        operator = "%";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null % null");
        operator = "mod";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null mod null");
    }

    private void runLambdaExpressions(String operator, Number expectedResult, String aType, String comparitorB, String bName) throws Exception {
        ELProcessor elp = new ELProcessor();
        elp.defineBean("types", (Object)new TypesBean());
        String comparitorA = "a=types.tck" + aType;
        elp.eval(comparitorA);
        elp.eval(comparitorB);
        Validator.testExpression(elp, "(x->(y->x " + operator + " y)(a))(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "(()->y->y " + operator + " a)()(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "f = (x)->(tem=x; y->tem " + operator + " y); f(a)(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "f = ()->y->y " + operator + " a; f()(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "f = (x)->(tem=x; y->tem " + operator + " y); f(a)(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expectedResult, aType + " " + operator + " " + bName);
        String zValue = "z = (x,y)->x " + operator + " y";
        elp.eval(zValue);
        Validator.testExpression(elp, "z(a, b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "func = (x,y)->x " + operator + " y; func(a, b)", expectedResult, aType + " " + operator + " " + bName);
        elp.eval("cond = true");
        Validator.testExpression(elp, "(cond->true? a " + operator + " b: a " + operator + " 2)(a)", expectedResult, aType + " " + operator + " " + bName);
        elp.eval("cond = false");
        Validator.testExpression(elp, "(cond->false? a " + operator + " 2: a " + operator + " b)(a)", expectedResult, aType + " " + operator + " " + bName);
    }
}

