/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.beanelresolver;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.BeanELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "beanelresolver_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    private SimpleBean sb = new SimpleBean();
    private Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="beanelresolver_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"beanelresolver_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, BarELResolver.class, ResolverTest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ELClientServletTest.class, BareBonesELContext.class, SimpleBean.class, SimpleInterface.class, ELTestUtil.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
        this.sb = new SimpleBean();
    }

    @AfterEach
    public void cleanup() throws Exception {
        TestUtil.logTrace((String)"Cleanup method called");
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        this.sb.setIntention("initial_setting");
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver((ELContext)context, (ELResolver)beanResolver, (Object)this.sb, (Object)"intention", (Object)"ABC123", (StringBuffer)buf, (boolean)false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverDefaultMethodReadOnlyTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver((ELContext)context, (ELResolver)beanResolver, (Object)this.sb, (Object)"defaultRO", (Object)"RO", (StringBuffer)buf, (boolean)true);
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Test of a valid expression using a Bean with a read-only property implemented via default methods threw an Exception!" + TestUtil.NEW_LINE + "Received: " + ex.toString() + TestUtil.NEW_LINE));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverDefaultMethodReadWriteTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver((ELContext)context, (ELResolver)beanResolver, (Object)this.sb, (Object)"defaultRW", (Object)"RW", (StringBuffer)buf, (boolean)false);
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Test of a valid expression using a Bean with a read-write property implemented via default methods threw an Exception!" + TestUtil.NEW_LINE + "Received: " + ex.toString() + TestUtil.NEW_LINE));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverInvokeTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            Class[] types = new Class[]{String.class, String.class};
            Object[] values = new String[]{"Doug", "Donahue"};
            pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)beanResolver, (Object)this.sb, (Object)"isName", (Class[])types, (Object[])values, (Boolean)Boolean.FALSE, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverInvokeVoidTest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            Class[] types = new Class[]{String.class, String.class};
            Object[] values = new String[]{"Peter", "Pan"};
            Object result = beanResolver.invoke(context, (Object)this.sb, (Object)"setFullName", types, values);
            if (null == result) {
                pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)beanResolver, (Object)this.sb, (Object)"isName", (Class[])types, (Object[])values, (Boolean)Boolean.FALSE, (StringBuffer)buf);
            } else {
                pass = false;
                buf.append("Unexpected Value returned!" + TestUtil.NEW_LINE + "Expected: null" + TestUtil.NEW_LINE + "Recieved: " + result.getClass().getName());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverInvokeMNFETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            Class[] types = new Class[]{String.class, String.class};
            Object[] values = new String[]{"Doug", "Donahue"};
            pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)beanResolver, (Object)this.sb, (Object)"bogus_Method", (Class[])types, (Object[])values, (Boolean)Boolean.TRUE, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        this.sb.setIntention("initial_setting");
        BeanELResolver resolver = new BeanELResolver();
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, (Object)this.sb, (Object)"intention", (Object)"billy", (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverPNFETest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        this.sb.setIntention("initial_setting");
        BeanELResolver resolver = new BeanELResolver();
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNFE((ELContext)context, (ELResolver)resolver, (Object)this.sb, (Object)"Bogus_Field", (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverPNWETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        BeanELResolver resolver = new BeanELResolver(true);
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNWE((ELContext)context, (ELResolver)resolver, (Object)this.sb, (Object)"intention", (Object)"billy", (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanELResolverMethodVisibilityTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        TimeZone tz = TimeZone.getDefault();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver((ELContext)context, (ELResolver)beanResolver, (Object)tz, (Object)"rawOffset", (Object)0, (StringBuffer)buf, (boolean)false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }
}

