/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.enventry;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ComponentBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.Interceptor3;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.interceptor.Interceptors;
import java.util.List;
import javax.naming.Context;

public abstract class BeanBase
extends ComponentBase {
    @Resource
    private EJBContext ejbContext;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.Client/myBooleanTrue", description="declared in web.xml")
    private boolean myBooleanTrueFromWebXml;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.Client/myBooleanFalse")
    private boolean myBooleanFalseFromWebXml;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.OneBean/myBooleanTrue", description="declared in ejb-jar.xml#OneBean")
    private boolean myBooleanTrue;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.OneBean/myBooleanFalse")
    private boolean myBooleanFalse;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.TwoBean/myBooleanTrue", description="declared in ejb-jar.xml#TwoBean")
    private boolean myBooleanTrueFromTwo;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.TwoBean/myBooleanFalse")
    private boolean myBooleanFalseFromTwo;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ThreeBean/myBooleanTrue", description="declared in ejb-jar.xml#ThreeBean")
    private boolean myBooleanTrueFromThree;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ThreeBean/myBooleanFalse")
    private boolean myBooleanFalseFromThree;
    @Resource(lookup="java:module/ModuleName")
    private String moduleNameInjected;
    @Resource(lookup="java:app/AppName")
    private String appNameInjected;

    @Interceptors(value={Interceptor3.class})
    public void getInjectionStatusForInterceptors(List<Boolean> sta) {
    }

    @Interceptors(value={Interceptor3.class})
    public void getInjectionRecordsForInterceptors(List<List<String>> rec) {
    }

    @PostConstruct
    private void postConstruct() {
        StringBuilder sb = new StringBuilder();
        try {
            Helper.assertNotEquals("Check injected EJBContext ", this.ejbContext, null);
            Helper.assertEquals("Check myBooleanTrue web.xml: ", true, this.myBooleanTrueFromWebXml, sb);
            Helper.assertEquals("Check myBooleanTrue from OneBean", true, this.myBooleanTrue, sb);
            Helper.assertEquals("Check myBooleanTrue from TwoBean", true, this.myBooleanTrueFromTwo, sb);
            Helper.assertEquals("Check myBooleanTrue from ThreeBean", true, this.myBooleanTrueFromThree, sb);
            Helper.assertEquals("Check myBooleanFalse from web.xml", false, this.myBooleanFalseFromWebXml, sb);
            Helper.assertEquals("Check myBooleanFalse from OneBean", false, this.myBooleanFalse, sb);
            Helper.assertEquals("Check myBooleanFalse from TwoBean", false, this.myBooleanFalseFromTwo, sb);
            Helper.assertEquals("Check myBooleanFalse from ThreeBean", false, this.myBooleanFalseFromThree, sb);
            this.setInjectionStatusAndRecord(true, sb.toString(), new Throwable[0]);
        }
        catch (Throwable e) {
            this.setInjectionStatusAndRecord(false, sb.toString(), e);
        }
    }

    public String appNameModuleName(String expected) {
        StringBuilder sb = new StringBuilder();
        String lookup = "java:module/ModuleName";
        String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check " + lookup, expected, actual, sb);
        Helper.assertEquals("Check injected value ", expected, this.moduleNameInjected, sb);
        lookup = "java:app/AppName";
        actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check " + lookup, expected, actual, sb);
        Helper.assertEquals("Check injected value ", expected, this.appNameInjected, sb);
        return sb.toString();
    }
}

