/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.stateless.lsecr;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.sec.stateless.common.SecTest;
import com.sun.ts.tests.ejb30.sec.stateless.common.SecTestLocal;
import jakarta.annotation.Resource;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Local;
import jakarta.ejb.Remote;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import java.util.Properties;

@Stateless(name="SecTestEJB")
@Remote(value={SecTest.class})
@Local(value={SecTestLocal.class})
public class SecTestEJB
implements SecTest {
    private SessionContext sctx;

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"SecTestEJB initLogging failed.");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean IsCaller(String caller) {
        return this.sctx.getCallerPrincipal().getName().indexOf(caller) >= 0;
    }

    @Override
    @RolesAllowed(value={"Administrator"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbNotAuthz() {
        return true;
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbIsAuthz() {
        return true;
    }

    @Override
    @RolesAllowed(value={"Manager"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbSecRoleRef(String role) {
        return this.sctx.isCallerInRole(role);
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbOverloadedSecRoleRefs(String role1) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ") = " + this.sctx.isCallerInRole(role1)));
        return this.sctx.isCallerInRole(role1);
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbOverloadedSecRoleRefs(String role1, String role2) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ")= " + this.sctx.isCallerInRole(role1) + "isCallerInRole(" + role2 + ")= " + this.sctx.isCallerInRole(role2)));
        return this.sctx.isCallerInRole(role1) && this.sctx.isCallerInRole(role2);
    }

    @Override
    @PermitAll
    public boolean checktest1() {
        TestUtil.logTrace((String)"In checktest1!");
        return true;
    }

    @Override
    @DenyAll
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean excludetest1() {
        return true;
    }

    @Resource
    public void setSessionContext(SessionContext sc) {
        this.sctx = sc;
    }
}

