/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.manyXmany;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.manyXmany.A;
import ee.jakarta.tck.persistence.core.entitytest.detach.manyXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachMXMTest1() throws Exception {
        A aRef = new A("1", "a1", 1);
        B b1 = new B("1", "b1", 1);
        B b2 = new B("2", "b2", 2);
        int foundB = 0;
        String[] expectedResults = new String[]{"1", "2"};
        boolean pass1 = true;
        boolean pass2 = false;
        try {
            this.logTrace("Begin detachMXMTest1");
            this.createA(aRef);
            this.logTrace("Call clean to detach");
            this.clearCache();
            this.getEntityTransaction().begin();
            if (!this.getEntityManager().contains((Object)aRef)) {
                this.logTrace("Status is false as expected, try merge");
                this.getEntityManager().merge((Object)aRef);
                aRef.getBCol().add(b1);
                aRef.getBCol().add(b2);
                this.getEntityManager().merge((Object)aRef);
                this.logTrace("findA and getBCol");
                A a1 = (A)this.getEntityManager().find(A.class, (Object)"1");
                Collection newCol = a1.getBCol();
                if (newCol.size() != 2) {
                    this.logErr("detachMXMTest1: Did not get expected results.Expected Collection Size of 2 B entities, got: " + newCol.size());
                    pass1 = false;
                } else if (pass1) {
                    Iterator i1 = newCol.iterator();
                    block11: while (i1.hasNext()) {
                        this.logTrace("Check Collection B entities");
                        B c1 = (B)i1.next();
                        for (int l = 0; l < 2; ++l) {
                            if (!expectedResults[l].equals(c1.getBId())) continue;
                            this.logTrace("Found B Entity : " + c1.getBName());
                            ++foundB;
                            continue block11;
                        }
                    }
                }
            } else {
                this.logTrace("entity is not detached, cannot proceed with test.");
                pass1 = false;
                pass2 = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception caught during commit:", e);
            pass1 = false;
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (foundB != 2) {
            this.logErr("detachMXMTest1: Did not get expected results");
            pass2 = false;
        } else {
            this.logTrace("Expected results received");
            pass2 = true;
        }
        if (!pass1 || !pass2) {
            throw new Exception("detachMXMTest1 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM FKEYS_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

