/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.timer.service.common;

import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb32.timer.service.common.TimerIF;
import jakarta.ejb.EJB;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;

public abstract class ClientBase
extends EJBLiteClientBase {
    private static final long ONE_HOUR_MILLIS = 3600000L;
    @EJB(beanName="TimersSingletonBean")
    protected TimerIF singletonBean;
    @EJB(beanName="TimersStatelessBean")
    protected TimerIF statelessBean;
    @EJB(beanName="NoTimersStatefulBean")
    protected TimerIF statefulBean;
    protected TimerIF clientBean;
    protected int autoTimerCount = 0;
    protected boolean ejbLite = false;
    private int programmaticTimerCount = 0;

    protected void createTimersProgrammatically(boolean persistent) {
        Calendar cal = Calendar.getInstance();
        cal.add(10, 1);
        ScheduleExpression se = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        this.singletonBean.createTimer(TimerUtil.getCurrentDatePlus((int)10, (int)1), this.newTimerConfig(persistent));
        this.singletonBean.createTimer(TimerUtil.getCurrentDatePlus((int)10, (int)1), 3600000L, this.newTimerConfig(persistent));
        this.singletonBean.createTimer(3600000L, this.newTimerConfig(persistent));
        this.singletonBean.createTimer(3600000L, 3600000L, this.newTimerConfig(persistent));
        this.singletonBean.createTimer(se, this.newTimerConfig(persistent));
        this.statelessBean.createTimer(TimerUtil.getCurrentDatePlus((int)10, (int)1), this.newTimerConfig(persistent));
        this.statelessBean.createTimer(TimerUtil.getCurrentDatePlus((int)10, (int)1), 3600000L, this.newTimerConfig(persistent));
        this.statelessBean.createTimer(3600000L, this.newTimerConfig(persistent));
        this.statelessBean.createTimer(3600000L, 3600000L, this.newTimerConfig(persistent));
        this.statelessBean.createTimer(se, this.newTimerConfig(persistent));
    }

    private TimerConfig newTimerConfig(boolean persistent) {
        TimerInfo ti = new TimerInfo(Integer.toString(this.programmaticTimerCount++));
        return new TimerConfig((Serializable)ti, persistent);
    }

    protected void passIfAllTimersRetrieved(Collection<Timer> allTimers) {
        this.assertEquals("Check the count of Timer objects retrieved is correct", this.programmaticTimerCount + this.autoTimerCount, allTimers.size());
        this.checkTimersIndexedByInfo(allTimers, this.programmaticTimerCount, false);
        this.checkTimersIndexedByInfo(allTimers, this.autoTimerCount, true);
    }

    private void checkTimersIndexedByInfo(Collection<Timer> allTimers, int count, boolean auto) {
        for (int i = 0; i < count; ++i) {
            Timer t = TimerUtil.findTimer(allTimers, (TimerInfo)new TimerInfo((auto ? "a" : "") + i));
            this.assertNotEquals("Check Timer object retrieved not null", null, t);
        }
    }

    public void testGetAllTimers() {
        if (!this.ejbLite) {
            this.createTimersProgrammatically(true);
        }
        this.createTimersProgrammatically(false);
        this.passIfAllTimersRetrieved(this.clientBean.getAllTimers());
    }
}

