/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.schemaGeneration.scripts;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.schemaGeneration.scripts.Simple;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    String schemaGenerationDir = null;
    String sTestCase = "jpa_se_schemaGeneration_scripts";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Simple"};
        return this.createDeploymentJar("jpa_se_schemaGeneration_scripts.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.schemaGenerationDir = System.getProperty("user.dir");
            if (!this.schemaGenerationDir.endsWith(File.separator)) {
                this.schemaGenerationDir = this.schemaGenerationDir + File.separator;
            }
            this.schemaGenerationDir = this.schemaGenerationDir + "schemaGeneration";
            logger.log(System.Logger.Level.INFO, "schemaGenerationDir=" + this.schemaGenerationDir);
            File f = new File(this.schemaGenerationDir);
            logger.log(System.Logger.Level.INFO, "Delete existing directory ");
            this.deleteItem(f);
            logger.log(System.Logger.Level.INFO, "Create new directory ");
            if (!f.mkdir()) {
                String msg = "Could not mkdir:" + f.getAbsolutePath();
                throw new Exception(msg);
            }
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void scriptsURLTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass1 = this.findDataInFile(f1, "create table schemaGenSimple");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass2 = this.findDataInFile(f2, expected);
        if (!pass1 || !pass2) {
            throw new Exception("scriptsURLTest failed");
        }
    }

    @Test
    public void scriptsPrintWriterTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = null;
        PrintWriter pw1 = null;
        try {
            f1 = new File(CREATEFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
            this.deleteItem(f1);
            pw1 = new PrintWriter(new File(CREATEFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        File f2 = null;
        PrintWriter pw2 = null;
        try {
            f2 = new File(DROPFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
            this.deleteItem(f2);
            pw2 = new PrintWriter(new File(DROPFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", pw1);
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", pw2);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        if (pw1 != null) {
            pw1.close();
        }
        if (pw2 != null) {
            pw2.close();
        }
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass1 = this.findDataInFile(f1, "create table schemaGenSimple");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass2 = this.findDataInFile(f2, expected);
        if (!pass1 || !pass2) {
            throw new Exception("scriptsPrintWriterTest failed");
        }
    }

    @Test
    public void scriptsURL2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass1 = this.findDataInFile(f1, "create table schemaGenSimple");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass2 = this.findDataInFile(f2, expected);
        if (!pass1 || !pass2) {
            throw new Exception("scriptsURL2Test failed");
        }
    }

    @Test
    public void scriptsPrintWriter2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = null;
        PrintWriter pw1 = null;
        try {
            f1 = new File(CREATEFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
            this.deleteItem(f1);
            pw1 = new PrintWriter(new File(CREATEFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        File f2 = null;
        PrintWriter pw2 = null;
        try {
            f2 = new File(DROPFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
            this.deleteItem(f2);
            pw2 = new PrintWriter(new File(DROPFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", pw1);
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", pw2);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        if (pw1 != null) {
            pw1.close();
        }
        if (pw2 != null) {
            pw2.close();
        }
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass1 = this.findDataInFile(f1, "create table schemaGenSimple");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass2 = this.findDataInFile(f2, expected);
        if (!pass1 || !pass2) {
            throw new Exception("scriptsPrintWriter2Test failed");
        }
    }

    @Test
    public void databaseAndScriptsURLTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass2 = this.findDataInFile(f1, "create table schemaGenSimple");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass3 = this.findDataInFile(f2, expected);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("databaseAndScriptsURLTest failed");
        }
    }

    @Test
    public void databaseAndScriptsPrintWriterTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = null;
        PrintWriter pw1 = null;
        try {
            f1 = new File(CREATEFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
            this.deleteItem(f1);
            pw1 = new PrintWriter(new File(CREATEFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        File f2 = null;
        PrintWriter pw2 = null;
        try {
            f2 = new File(DROPFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
            this.deleteItem(f2);
            pw2 = new PrintWriter(new File(DROPFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", pw1);
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", pw2);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        if (pw1 != null) {
            pw1.close();
        }
        if (pw2 != null) {
            pw2.close();
        }
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass2 = this.findDataInFile(f1, "create table schemaGenSimple");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass3 = this.findDataInFile(f2, expected);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("databaseAndScriptsPrintWriterTest failed");
        }
    }

    @Test
    public void databaseAndScriptsURL2Test() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        if (!pass) {
            throw new Exception("databaseAndScriptsURL2Test failed");
        }
    }

    @Test
    public void databaseAndScriptsPrintWriter2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = null;
        PrintWriter pw1 = null;
        try {
            f1 = new File(CREATEFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
            this.deleteItem(f1);
            pw1 = new PrintWriter(new File(CREATEFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        File f2 = null;
        PrintWriter pw2 = null;
        try {
            f2 = new File(DROPFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
            this.deleteItem(f2);
            pw2 = new PrintWriter(new File(DROPFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", pw1);
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", pw2);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        if (pw1 != null) {
            pw1.close();
        }
        if (pw2 != null) {
            pw2.close();
        }
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass2 = this.findDataInFile(f1, "create table schemaGenSimple");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass3 = this.findDataInFile(f2, expected);
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("databaseAndScriptsPrintWriter2Test failed");
        }
    }

    @Test
    public void databaseCreateTest() throws Exception {
        boolean pass = false;
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        if (!pass) {
            throw new Exception("databaseCreateTest failed");
        }
    }

    @Test
    public void executeCreateScriptURLTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        Properties props = this.getPersistenceUnitProperties();
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass1 = this.findDataInFile(f1, "create table schemaGenSimple");
        logger.log(System.Logger.Level.TRACE, "Execute the create script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.create-script-source", this.convertToURI(CREATEFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        if (!pass1 || !pass2) {
            throw new Exception("executeCreateScriptURLTest failed");
        }
    }

    @Test
    public void executeCreateScriptReaderTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        File f1 = null;
        PrintWriter pw1 = null;
        try {
            f1 = new File(CREATEFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
            this.deleteItem(f1);
            pw1 = new PrintWriter(new File(CREATEFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", pw1);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        pass1 = this.findDataInFile(f1, "create table schemaGenSimple");
        logger.log(System.Logger.Level.INFO, "Execute the script");
        props = this.getPersistenceUnitProperties();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f1));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.create-script-source", reader);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        if (pw1 != null) {
            pw1.close();
        }
        if (reader != null) {
            ((Reader)reader).close();
        }
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        if (!pass1 || !pass2) {
            throw new Exception("executeCreateScriptReaderTest failed");
        }
    }

    @Test
    public void executeDropScriptURLTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass1 = this.findDataInFile(f2, expected);
        logger.log(System.Logger.Level.TRACE, "Generate schema");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.TRACE, "Execute the drop script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.drop-script-source", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.INFO, "Try to persist an entity, it should fail");
        try {
            this.getEntityTransaction(true).begin();
            Simple s3 = new Simple(2, "2");
            this.getEntityManager().persist((Object)s3);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "An exception should have been thrown if drop had occurred successfully");
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.TRACE, "Received expected exception");
            pass3 = true;
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("executeDropScriptURLTest failed");
        }
    }

    @Test
    public void executeDropScriptReaderTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f2 = null;
        PrintWriter pw2 = null;
        try {
            f2 = new File(DROPFILENAME);
            logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
            this.deleteItem(f2);
            pw2 = new PrintWriter(new File(DROPFILENAME));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", pw2);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        if (pw2 != null) {
            pw2.close();
        }
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("drop table");
        expected.add("schemaGenSimple");
        pass1 = this.findDataInFile(f2, expected);
        logger.log(System.Logger.Level.TRACE, "Generate schema");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.TRACE, "Try to persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1, "1");
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            this.getEntityTransaction().commit();
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.TRACE, "Execute the drop script");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f2));
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred:" + ex);
        }
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.drop-script-source", reader);
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        if (reader != null) {
            ((Reader)reader).close();
        }
        logger.log(System.Logger.Level.INFO, "Try to persist an entity, it should fail because table should not exist");
        try {
            this.getEntityTransaction(true).begin();
            Simple s3 = new Simple(2, "2");
            this.getEntityManager().persist((Object)s3);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "An exception should have been thrown if drop script executed successfully");
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.TRACE, "Received expected exception");
            pass3 = true;
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("executeDropScriptReaderTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Try to drop table SCHEMAGENSIMPLE");
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGENSIMPLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.INFO, "AN EXCEPTION WAS THROWN DURING DROP TABLE SCHEMAGENSIMPLE, IT MAY OR MAY NOT BE A PROBLEM, " + t.getMessage());
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
                this.clearEntityTransaction();
                this.clearEMAndEMF();
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

