/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.apitests;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.apitests.Department;
import ee.jakarta.tck.persistence.core.query.apitests.Employee;
import jakarta.persistence.Query;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    final Department[] deptRef = new Department[5];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes2", pkgName + "Department", pkgName + "Employee", pkgName + "Insurance"};
        return this.createDeploymentJar("jpa_core_query_apitests2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupNoData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception caught in Setup: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupNoData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "in cleanupNoData");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void getParameterIntIllegalArgumentException2Test() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Tom");
            query.getParameter(1, List.class);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Tom");
            query.getParameter(1, List.class);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterIntIllegalArgumentException2Test failed");
        }
    }
}

