/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.attributeoverride;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.attributeoverride.LawBook;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final int ENTITY_ID = 3039;
    private static final String NAME = "Cheese";
    private static final String PUBLISHER = "Johnson";
    private static final int COST = 20;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "Book", pkgName + "LawBook"};
        return this.createDeploymentJar("jpa_core_override_attributeoverride.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception:test failed ", (Throwable)e);
        }
    }

    @Test
    public void testNoAttributeOverrideAnnotation() throws Exception {
        block6: {
            LawBook book = new LawBook();
            this.getEntityTransaction().begin();
            book.setCategory("Motivational");
            book.setId(3039);
            book.setName(NAME);
            book.setPublisher(PUBLISHER);
            book.setCost(20);
            this.getEntityManager().persist((Object)book);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createQuery("SELECT b FROM LawBook b where b.name= :name").setParameter("name", (Object)NAME).getResultList();
                if (result.size() == 1) {
                    logger.log(System.Logger.Level.TRACE, "test Overriding Attributes passed");
                    break block6;
                }
                throw new Exception("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoAttributeOverrideAnnotation" + e);
            }
            finally {
                this.getEntityManager().remove((Object)book);
                this.getEntityTransaction().commit();
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM LAWBOOK").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

