/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.listattribute;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.listattribute.BiDirMX1Person;
import ee.jakarta.tck.persistence.core.metamodelapi.listattribute.BiDirMX1Project;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "BiDirMX1Person", pkgName + "BiDirMX1Project"};
        return this.createDeploymentJar("jpa_core_metamodelapi_listattribute.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getList() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getList("biDirMX1Persons", BiDirMX1Person.class);
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        String name = t.getJavaType().getName();
                        if (name.equals("ee.jakarta.tck.persistence.core.metamodelapi.listattribute.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: BiDirMX1Person, actual:" + name);
                        }
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getList Test  failed");
        }
    }

    @Test
    public void getCollectionType() throws Exception {
        boolean pass = false;
        String expected = PluralAttribute.CollectionType.LIST.name();
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getList("biDirMX1Persons", BiDirMX1Person.class);
                    PluralAttribute.CollectionType t = listAttrib.getCollectionType();
                    if (t != null) {
                        String sType = t.name();
                        if (sType.equals(expected)) {
                            logger.log(System.Logger.Level.TRACE, "Received expected: " + expected);
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + sType);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getCollectionType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCollectionType Test failed");
        }
    }

    @Test
    public void getDeclaredList() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getDeclaredList("biDirMX1Persons", BiDirMX1Person.class);
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        String name = t.getJavaType().getName();
                        if (name.equals("ee.jakarta.tck.persistence.core.metamodelapi.listattribute.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: BiDirMX1Person, actual:" + name);
                        }
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredList Test  failed");
        }
    }

    @Test
    public void getList2() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getList("biDirMX1Persons");
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        String name = t.getJavaType().getName();
                        if (name.equals("ee.jakarta.tck.persistence.core.metamodelapi.listattribute.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: BiDirMX1Person, actual:" + name);
                        }
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getList2 Test  failed");
        }
    }

    @Test
    public void getDeclaredList2() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getDeclaredList("biDirMX1Persons");
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        String name = t.getJavaType().getName();
                        if (name.equals("ee.jakarta.tck.persistence.core.metamodelapi.listattribute.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: BiDirMX1Person, actual:" + name);
                        }
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredList2 Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
        }
    }
}

