/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityTransaction;

import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    Properties props = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{};
        return this.createDeploymentJar("jpa_core_entityTransaction.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "done cleanup, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void beginIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            if (t.isActive()) {
                try {
                    t.begin();
                    logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "isActive() returned false when a transaction was active");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("beginIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commitIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.commit();
                    logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "isActive() returened true when no transaction  was active");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("commitIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getRollbackOnlyIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.getRollbackOnly();
                    logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("getRollbackOnlyIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void rollbackIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.rollback();
                    logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("rollbackIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setRollbackOnlyIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.setRollbackOnly();
                    logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("setRollbackOnlyIllegalStateExceptionTest failed");
        }
    }
}

