/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex5b;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex5b.DID5bMedicalHistory;
import ee.jakarta.tck.persistence.core.derivedid.ex5b.DID5bPerson;
import ee.jakarta.tck.persistence.core.derivedid.ex5b.DID5bPersonId;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID5bMedicalHistory", pkgName + "DID5bPerson", pkgName + "DID5bPersonId"};
        return this.createDeploymentJar("jpa_core_derivedid_ex5b.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DIDTest() throws Exception {
        boolean pass = false;
        boolean pass1 = false;
        boolean pass2 = true;
        try {
            this.getEntityTransaction().begin();
            DID5bPersonId personId = new DID5bPersonId("Java", "DUKE");
            DID5bPerson person = new DID5bPerson(personId, "123456789");
            DID5bMedicalHistory mHistory = new DID5bMedicalHistory(personId, person, "drFoo");
            this.getEntityManager().persist((Object)person);
            this.getEntityManager().persist((Object)mHistory);
            logger.log(System.Logger.Level.TRACE, "persisted Patient and MedicalHistory");
            this.getEntityManager().flush();
            DID5bMedicalHistory newMHistory = (DID5bMedicalHistory)this.getEntityManager().find(DID5bMedicalHistory.class, (Object)new DID5bPersonId("Java", "DUKE"));
            if (newMHistory != null) {
                this.getEntityManager().refresh((Object)newMHistory);
            }
            List depList = this.getEntityManager().createQuery("Select m from DID5bMedicalHistory m where m.patient.firstName='Java'").getResultList();
            newMHistory = null;
            if (depList.size() > 0) {
                newMHistory = (DID5bMedicalHistory)depList.get(0);
                if (newMHistory.getPatient() == person) {
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Patient");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Patient not found");
                }
            }
            List depList2 = this.getEntityManager().createQuery("Select m from DID5bMedicalHistory m where m.id.firstName='Java'").getResultList();
            DID5bMedicalHistory newMHistory2 = null;
            if (depList2.size() > 0) {
                newMHistory2 = (DID5bMedicalHistory)depList.get(0);
                if (newMHistory2 != null) {
                    if (newMHistory2.getPatient() == person) {
                        pass = true;
                        logger.log(System.Logger.Level.TRACE, "Received Expected Patient");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Searched Patient not found");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (pass1 && pass2) {
            pass = true;
        }
        if (!pass) {
            throw new Exception("DIDTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID5BMEDICALHISTORY").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID5BPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

