/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.strquery;

import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.UtilSetup;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilSetup {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_strquery1.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void joinTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            logger.log(System.Logger.Level.INFO, "Testing default getJoinType");
            JoinType jt = customer.join("aliases").getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected:" + jt.name());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + JoinType.INNER.name() + ", actual:" + jt);
            }
            cquery = null;
            logger.log(System.Logger.Level.INFO, "Testing INNER getJoinType");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            jt = customer.join("aliases", JoinType.INNER).getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + JoinType.INNER.name() + ", actual:" + jt);
            }
            cquery = null;
            logger.log(System.Logger.Level.INFO, "Testing LEFT getJoinType");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            jt = customer.join("aliases", JoinType.LEFT).getJoinType();
            if (jt.equals((Object)JoinType.LEFT)) {
                logger.log(System.Logger.Level.TRACE, "Received expected:" + jt.name());
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + JoinType.LEFT.name() + ", actual:" + jt);
            }
            cquery = null;
            logger.log(System.Logger.Level.INFO, "Testing INNER getAttribute");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            Attribute attr = customer.join("aliases").getAttribute();
            if (attr.getName().equals("aliases")) {
                logger.log(System.Logger.Level.TRACE, "Received expected:" + attr.getName());
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:aliases, actual:" + attr.getName());
            }
            cquery = null;
            logger.log(System.Logger.Level.INFO, "Testing getParent");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            From from = customer.join("aliases").getParent();
            if (from.getClass().getName().equals(customer.getClass().getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected:" + from.getClass().getName());
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + customer.getClass().getName() + ", actual:" + from.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("joinTest failed");
        }
    }

    @Test
    public void fetchStringAndStringJoinTypeIllegalArgumentException() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        logger.log(System.Logger.Level.INFO, "Testing String");
        try {
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            customer.fetch("doesnotexist");
            logger.log(System.Logger.Level.ERROR, "did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing String, JoinType");
        try {
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            customer.fetch("doesnotexist", JoinType.INNER);
            logger.log(System.Logger.Level.ERROR, "did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchStringAndStringJoinTypeIllegalArgumentException failed");
        }
    }
}

