/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.Join;

import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Employee;
import ee.jakarta.tck.persistence.common.schema30.Employee_;
import ee.jakarta.tck.persistence.common.schema30.UtilSetup;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.SetJoin;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilSetup {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_join.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void joinStringIllegalArgumentExceptionTest() throws Exception {
        CollectionJoin order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.join("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.join("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinCollectionIllegalArgumentExceptionTest() throws Exception {
        CollectionJoin order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.joinCollection("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.joinCollection("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinCollectionIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinSetIllegalArgumentExceptionTest() throws Exception {
        SetJoin order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders2);
            try {
                order.joinSet("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders2);
            try {
                order.joinSet("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinSetIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinListIllegalArgumentExceptionTest() throws Exception {
        Join order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join("orders3");
            try {
                order.joinList("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join("orders3");
            try {
                order.joinList("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinListIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinMapIllegalArgumentExceptionTest() throws Exception {
        Join department;
        Root employee;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Employee.class);
            employee = cquery.from(Employee.class);
            department = employee.join(Employee_.department);
            try {
                department.joinMap("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Employee.class);
            employee = cquery.from(Employee.class);
            department = employee.join(Employee_.department);
            try {
                department.joinMap("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinMapIllegalArgumentExceptionTest failed");
        }
    }
}

