/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaUpdate;

import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct;
import ee.jakarta.tck.persistence.common.schema30.UtilProductData;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client
extends UtilProductData {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaUpdate.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void fromClassGetRootSetStringObjectTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            if (root.equals(cd.getRoot())) {
                logger.log(System.Logger.Level.TRACE, "Obtained expected root");
                cd.set("quantity", (Object)0);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected number deleted:" + actual);
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass4 = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get expected root");
                logger.log(System.Logger.Level.ERROR, "Expected:" + cd.getRoot() + ", actual:" + root);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("fromClassGetRootSetStringObjectTest failed");
        }
    }

    @Test
    public void fromEntityTypeSetStringObjectTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Metamodel mm = this.getEntityManager().getMetamodel();
        EntityType Product_ = mm.entity(Product.class);
        Root root = cd.from(Product_);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            cd.set("quantity", (Object)0);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                Product pp;
                pass1 = true;
                logger.log(System.Logger.Level.TRACE, "Received expected number deleted:" + actual);
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                    pass2 = false;
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                    pass3 = false;
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                    pass4 = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("fromEntityTypeSetStringObjectTest failed");
        }
    }

    @Test
    public void whereExpressionTest() throws Exception {
        boolean pass2 = false;
        boolean pass3 = true;
        boolean pass4 = true;
        boolean pass5 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            EntityType product_ = root.getModel();
            cd.set(product_.getSingularAttribute("quantity", Integer.class), (Object)0);
            Path exp = root.get("id");
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            col.add("2");
            col.add("3");
            cd.where((Expression)exp.in(col));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == col.size()) {
                Product pp;
                logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                pass2 = true;
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (product.getId().equals("1") || product.getId().equals("2") || product.getId().equals("3")) {
                        if (pp.getQuantity() != 0) {
                            logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                            pass3 = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "Product:" + product.getId() + " update was successfully");
                        continue;
                    }
                    if (pp.getQuantity() != product.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "Product:" + product.getId() + " quantity does not equal original value:" + product.getQuantity());
                        pass3 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Product:" + pp.getId() + " quantity matches original value" + product.getQuantity());
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity());
                        pass4 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Received expected software quantity:" + pp.getQuantity());
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity());
                        pass5 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Received expected hardware quantity:" + pp.getQuantity());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + col.size() + ", actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("whereExpressionTest failed");
        }
    }

    @Test
    public void wherePredicateArrayTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            EntityType product_ = root.getModel();
            cd.set(product_.getSingularAttribute("quantity", Integer.class), (Object)0);
            Predicate[] predArray = new Predicate[]{cbuilder.equal((Expression)root.get("id"), (Object)"2")};
            cd.where(predArray);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == predArray.length) {
                Product pp;
                logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                pass1 = true;
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (product.getId().equals("2")) {
                        if (pp.getQuantity() != 0) {
                            logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                            pass2 = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "Product:" + product.getId() + " update was successfully");
                        continue;
                    }
                    if (pp.getQuantity() != product.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "Product:" + product.getId() + " quantity does not equal original value:" + product.getQuantity());
                        pass2 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Product:" + pp.getId() + " quantity matches original value" + product.getQuantity());
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity());
                        pass3 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Received expected software quantity:" + pp.getQuantity());
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity());
                        pass4 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Received expected hardware quantity:" + pp.getQuantity());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected updates:" + predArray.length + ", actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("wherePredicateArrayTest failed");
        }
    }

    @Test
    public void setSingularAttributeObjectTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                logger.log(System.Logger.Level.TRACE, "Obtained expected root");
                EntityType product_ = root.getModel();
                cd.set(product_.getSingularAttribute("quantity", Integer.class), (Object)0);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass4 = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get expected root");
                logger.log(System.Logger.Level.ERROR, "Expected:" + cd.getRoot().getModel().getName() + ", actual:" + root.getModel().getName());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setSingularAttributeObjectTest failed");
        }
    }

    @Test
    public void setSingularAttributeExpressionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                logger.log(System.Logger.Level.TRACE, "Obtained expected root");
                EntityType product_ = root.getModel();
                Expression exp = cbuilder.prod((Expression)root.get(product_.getSingularAttribute("quantity", Integer.class)), (Number)0);
                cd.set(product_.getSingularAttribute("quantity", Integer.class), exp);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass4 = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get expected root");
                logger.log(System.Logger.Level.ERROR, "Expected:" + cd.getRoot().getModel().getName() + ", actual:" + root.getModel().getName());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setSingularAttributeExpressionTest failed");
        }
    }

    @Test
    public void setPathObjectTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                logger.log(System.Logger.Level.TRACE, "Obtained expected root");
                cd.set(root.get("quantity"), (Object)0);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                        pass4 = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get expected root");
                logger.log(System.Logger.Level.ERROR, "Expected:" + cd.getRoot().getModel().getName() + ", actual:" + root.getModel().getName());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setPathObjectTest failed");
        }
    }

    @Test
    public void setPathExpressionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            EntityType product_ = root.getModel();
            Expression exp = cbuilder.prod((Expression)root.get(product_.getSingularAttribute("quantity", Integer.class)), (Number)0);
            cd.set(root.get("quantity"), exp);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                Product pp;
                pass1 = true;
                logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                    pass2 = false;
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                    pass3 = false;
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                    pass4 = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setPathExpressionTest failed");
        }
    }

    @Test
    public void subquery() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cu = cbuilder.createCriteriaUpdate(Product.class);
        if (cu != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root product = cu.from(Product.class);
            EntityType product_ = product.getModel();
            Expression exp = cbuilder.prod((Expression)product.get(product_.getSingularAttribute("quantity", Integer.class)), (Number)0);
            cu.set(product.get("quantity"), exp);
            EntityType Product_ = product.getModel();
            Subquery sq = cu.subquery(Product.class);
            Root hardProd = sq.from(Product.class);
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1")).select((Expression)hardProd);
            cu.where((Expression)cbuilder.exists(sq));
            int actual = this.getEntityManager().createQuery(cu).executeUpdate();
            if (actual == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                this.clearCache();
                Product pp = (Product)this.getEntityManager().find(Product.class, (Object)"1");
                if (pp.getQuantity() != 0) {
                    logger.log(System.Logger.Level.ERROR, "Expected product:1 to have quantity of 0, actual:" + pp.getQuantity());
                } else {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:1, actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("exists test failed");
        }
    }

    @Test
    public void modifiedQueryTest() throws Exception {
        int passModifiedCount1 = 0;
        int passUnModifiedCount1 = 0;
        int passModifiedCount2 = 0;
        int passUnModifiedCount2 = 0;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        logger.log(System.Logger.Level.INFO, "Testing initial query");
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(SoftwareProduct.class);
        Root softwareproduct = cd.from(SoftwareProduct.class);
        if (softwareproduct != null) {
            Product pp;
            EntityType softwareproduct_ = softwareproduct.getModel();
            cd.set(softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Object)0);
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)35));
            Query q = this.getEntityManager().createQuery(cd);
            logger.log(System.Logger.Level.INFO, "Modify CriteriaUpdate object");
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)500));
            int actual = q.executeUpdate();
            if (actual == 4) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp.getQuantity() != 0) {
                            logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "id:" + p.getId() + " update was successfully");
                        ++passModifiedCount1;
                        continue;
                    }
                    if (pp.getQuantity() != p.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + " quantity does not equal original value:" + p.getQuantity());
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "id:" + pp.getId() + " quantity matches original value:" + p.getQuantity());
                    ++passUnModifiedCount1;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected: 4 updates, actual:" + actual);
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + ", quantity:" + pp.getQuantity());
                }
            }
            logger.log(System.Logger.Level.INFO, "Testing modified CriteriaQuery");
            cd.where((Expression)cbuilder.gt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)100));
            actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 3) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of updates:" + actual);
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("29") || p.getId().equals("34") || p.getId().equals("38") || p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp.getQuantity() != 0) {
                            logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + " to have quantity of 0, actual:" + pp.getQuantity());
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "id:" + p.getId() + " update was successfully");
                        ++passModifiedCount2;
                        continue;
                    }
                    if (pp.getQuantity() != p.getQuantity()) {
                        logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + " quantity does not equal original value:" + p.getQuantity());
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "id:" + pp.getId() + " quantity matches original value:" + p.getQuantity());
                    ++passUnModifiedCount2;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected: 3, actual:" + actual);
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + ", quantity:" + pp.getQuantity());
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (passModifiedCount1 != 4 || passUnModifiedCount1 != 6 || passModifiedCount2 != 7 || passUnModifiedCount2 != 3) {
            throw new Exception("modifiedQueryTest failed");
        }
    }

    public void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

