/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.CriteriaEntity;
import ee.jakarta.tck.persistence.common.schema30.UtilCriteriaEntityData;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Parameter;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.LocalDateField;
import jakarta.persistence.criteria.LocalTimeField;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.TemporalField;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client9
extends UtilCriteriaEntityData {
    private static final System.Logger logger = System.getLogger(Client9.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client9.class.getPackageName();
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaBuilder9.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void andPredicateAsListOf0Test() throws Exception {
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.select((Selection)root);
            cQuery.where((Expression)cb.and(Collections.emptyList()));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            List result = query.getResultList();
            if (this.criteriaEntity.length == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |" + this.criteriaEntity.length + "|, received size= |" + result.size() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("andPredicateAsListOf0Test failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testOrPredicateAsListOf0() throws Exception {
        boolean EXPECTED_SIZE = false;
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.select((Selection)root);
            cQuery.where((Expression)cb.or(Collections.emptyList()));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            List result = query.getResultList();
            if (0 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |0|, received size= |" + result.size() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("testOrPredicateAsListOf0 failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testAndPredicateAsListOf1() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.and(List.of(cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam1")))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam1", (Object)"LeftToken");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (3L == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[0].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testAndPredicateAsListOf1 failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testOrPredicateAsListOf1() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.or(List.of(cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam1")))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam1", (Object)"LeftToken");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (3L == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[0].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testOrPredicateAsListOf1 failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testAndPredicateAsListOf2() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.and(List.of(cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam1")), cb.equal((Expression)root.get("strVal2"), (Expression)cb.parameter(String.class, "strParam2")))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam1", (Object)"LeftToken");
            query.setParameter("strParam2", (Object)"TokenRight");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (3L == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[0].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testAndPredicateAsListOf2 failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testOrPredicateAsListOf2() throws Exception {
        int EXPECTED_SIZE = 2;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.or(List.of(cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam1")), cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam2")))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam1", (Object)"Left");
            query.setParameter("strParam2", (Object)"right");
            List result = query.getResultList();
            if (2 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |2|, received size= |" + result.size() + "|");
            }
            Set resultSet = result.stream().map(CriteriaEntity::getId).collect(Collectors.toUnmodifiableSet());
            Set<Long> expectedSet = Set.of(Long.valueOf(1L), Long.valueOf(2L));
            if (Client9.compareFromSet(expectedSet, resultSet) == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result:|" + Client9.setToString(resultSet) + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + Client9.setToString(expectedSet) + "|, received result= |" + Client9.setToString((Set)((Object)result)) + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testOrPredicateAsListOf2 failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testAndPredicateAsListOfN() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.and(List.of(cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam1")), cb.equal((Expression)root.get("strVal2"), (Expression)cb.parameter(String.class, "strParam2")), cb.isNull((Expression)root.get("intVal")), cb.isNull((Expression)root.get("timeVal")))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam1", (Object)"LeftToken");
            query.setParameter("strParam2", (Object)"TokenRight");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (3L == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[0].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testAndPredicateAsListOfN failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testOrPredicateAsListOfN() throws Exception {
        int EXPECTED_SIZE = 4;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.or(List.of(cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam1")), cb.equal((Expression)root.get("strVal1"), (Expression)cb.parameter(String.class, "strParam2")), cb.equal((Expression)root.get("timeVal"), (Expression)cb.parameter(LocalTime.class, "timeParam")), cb.equal((Expression)root.get("dateVal"), (Expression)cb.parameter(LocalDate.class, "dateParam")))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam1", (Object)"Left");
            query.setParameter("strParam2", (Object)"right");
            query.setParameter("timeParam", (Object)LocalTime.of(10, 11, 12));
            query.setParameter("dateParam", (Object)LocalDate.of(1918, 9, 28));
            List result = query.getResultList();
            if (4 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |4|, received size= |" + result.size() + "|");
            }
            Set resultSet = result.stream().map(CriteriaEntity::getId).collect(Collectors.toUnmodifiableSet());
            Set<Long> expectedSet = Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(4L), Long.valueOf(5L));
            if (Client9.compareFromSet(expectedSet, resultSet) == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result:|" + Client9.setToString(resultSet) + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + Client9.setToString(expectedSet) + "|, received result= |" + Client9.setToString((Set)((Object)result)) + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testOrPredicateAsListOfN failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testLeftIntLen() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam1 = cb.parameter(String.class, "strParam1");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal1"), cb.left((Expression)strParam1, 4)));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam1, (Object)"Left substring to extract");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[0].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[0].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testLeftIntLen failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testLeftExprLen() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam1 = cb.parameter(String.class, "strParam1");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal1"), cb.left((Expression)strParam1, cb.literal((Object)4))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam1, (Object)"Left substring to extract");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[0].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[0].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testLeftExprLen failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testRightIntLen() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam1 = cb.parameter(String.class, "strParam1");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal1"), cb.right((Expression)strParam1, 5)));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam1, (Object)"Extract substring from right");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[1].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[1].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testRightIntLen failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testRightExprLen() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam1 = cb.parameter(String.class, "strParam1");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal1"), cb.right((Expression)strParam1, cb.literal((Object)5))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam1, (Object)"Extract substring from right");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[1].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[1].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testRightExprLen failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testReplaceExprExpr() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam1 = cb.parameter(String.class, "strParam1");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal1"), cb.replace((Expression)strParam1, cb.literal((Object)"Unknown"), cb.literal((Object)"Left"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam1, (Object)"UnknownToken");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[2].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[2].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testRightExprLen failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testReplaceExprStr() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam2 = cb.parameter(String.class, "strParam2");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal2"), cb.replace((Expression)strParam2, cb.literal((Object)"Unknown"), "Right")));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam2, (Object)"TokenUnknown");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[2].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[2].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testReplaceExprStr failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testReplaceStrExpr() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam1 = cb.parameter(String.class, "strParam1");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal1"), cb.replace((Expression)strParam1, "Unknown", cb.literal((Object)"Left"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam1, (Object)"UnknownToken");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[2].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[2].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testReplaceStrExpr failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testReplaceStrStr() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            ParameterExpression strParam2 = cb.parameter(String.class, "strParam2");
            cQuery.where((Expression)cb.equal((Expression)root.get("strVal2"), cb.replace((Expression)strParam2, "Unknown", "Right")));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter((Parameter)strParam2, (Object)"TokenUnknown");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[2].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[2].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testReplaceStrStr failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractHourFromTime() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "timeParam"), cb.extract((TemporalField)LocalTimeField.HOUR, (Expression)root.get("timeVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("timeParam", (Object)10);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[3].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[3].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractHourFromTime failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractMinuteFromTime() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "timeParam"), cb.extract((TemporalField)LocalTimeField.MINUTE, (Expression)root.get("timeVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("timeParam", (Object)11);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[3].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[3].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractMinuteFromTime failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractSecondFromTime() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "timeParam"), cb.extract((TemporalField)LocalTimeField.SECOND, (Expression)root.get("timeVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("timeParam", (Object)12.0);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[3].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[3].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractSecondFromTime failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractYearFromDate() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "dateParam"), cb.extract((TemporalField)LocalDateField.YEAR, (Expression)root.get("dateVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("dateParam", (Object)1918);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[4].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[4].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractYearFromDate failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractMonthFromDate() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "dateParam"), cb.extract((TemporalField)LocalDateField.MONTH, (Expression)root.get("dateVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("dateParam", (Object)9);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[4].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[4].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractMonthFromDate failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractDayFromDate() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "dateParam"), cb.extract((TemporalField)LocalDateField.DAY, (Expression)root.get("dateVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("dateParam", (Object)28);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[4].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[4].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractDayFromDate failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractQuarterFromDate() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "dateParam"), cb.extract((TemporalField)LocalDateField.QUARTER, (Expression)root.get("dateVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("dateParam", (Object)3);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[4].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[4].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractQuarterFromDate failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExtractWeekFromDate() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)cb.equal((Expression)cb.parameter(Integer.class, "dateParam"), cb.extract((TemporalField)LocalDateField.WEEK, (Expression)root.get("dateVal"))));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("dateParam", (Object)39);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[4].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[4].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExtractWeekFromDate failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExpressionEqualToExpression() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)root.get("strVal1").equalTo((Expression)cb.parameter(String.class, "strParam")));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam", (Object)"LeftToken");
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[2].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[2].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExpressionEqualToExpression failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExpressionEqualToObject() throws Exception {
        boolean EXPECTED_SIZE = true;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)root.get("strVal1").equalTo((Object)"LeftToken"));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            List result = query.getResultList();
            if (1 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |1|, received size= |" + result.size() + "|");
            }
            if (this.criteriaEntity[2].getId() == ((CriteriaEntity)result.get(0)).getId()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result.get(0).getId():|" + ((CriteriaEntity)result.get(0)).getId() + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + this.criteriaEntity[2].getId() + "|, received result= |" + ((CriteriaEntity)result.get(0)).getId() + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExpressionEqualToObject failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExpressionNotEqualToExpression() throws Exception {
        int EXPECTED_SIZE = 2;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)root.get("strVal1").notEqualTo((Expression)cb.parameter(String.class, "strParam")));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            query.setParameter("strParam", (Object)"LeftToken");
            List result = query.getResultList();
            if (2 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |2|, received size= |" + result.size() + "|");
            }
            Set resultSet = result.stream().map(CriteriaEntity::getId).collect(Collectors.toUnmodifiableSet());
            Set<Long> expectedSet = Set.of(Long.valueOf(1L), Long.valueOf(2L));
            if (Client9.compareFromSet(expectedSet, resultSet) == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result:|" + Client9.setToString(resultSet) + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + Client9.setToString(expectedSet) + "|, received result= |" + Client9.setToString((Set)((Object)result)) + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExpressionNotEqualToExpression failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    @Test
    public void testExpressionNotEqualToObject() throws Exception {
        int EXPECTED_SIZE = 2;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cQuery = cb.createQuery(CriteriaEntity.class);
        if (cQuery != null) {
            Root root = cQuery.from(CriteriaEntity.class);
            cQuery.where((Expression)root.get("strVal1").notEqualTo((Object)"LeftToken"));
            TypedQuery query = this.getEntityManager().createQuery(cQuery);
            List result = query.getResultList();
            if (2 == result.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected result size:|" + result.size() + "|");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected size= |2|, received size= |" + result.size() + "|");
            }
            Set resultSet = result.stream().map(CriteriaEntity::getId).collect(Collectors.toUnmodifiableSet());
            Set<Long> expectedSet = Set.of(Long.valueOf(1L), Long.valueOf(2L));
            if (Client9.compareFromSet(expectedSet, resultSet) == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected result result:|" + Client9.setToString(resultSet) + "|");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected result = |" + Client9.setToString(expectedSet) + "|, received result= |" + Client9.setToString((Set)((Object)result)) + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("testExpressionNotEqualToObject failed");
        }
    }

    @Test
    public void testExpressionCast() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        ParameterExpression source = cb.parameter(Integer.class, "intParam");
        if (Integer.class == source.getJavaType()) {
            logger.log(System.Logger.Level.TRACE, "Received result is |Integer.class|.");
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected type= |Integer.class|, received type= |" + source.getJavaType().getName() + "|");
        }
        Expression target = source.cast(Long.class);
        if (Long.class == target.getJavaType()) {
            logger.log(System.Logger.Level.TRACE, "Received result is |Long.class|.");
            pass2 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected type= |Long.class|, received type= |" + source.getJavaType().getName() + "|");
        }
        if (source != target) {
            logger.log(System.Logger.Level.TRACE, "Received instances are different.");
            pass3 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Received instances are same.");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("testExpressionCast failed");
        }
    }

    private static <T> String compareFromSet(Set<T> expected, Collection<T> actual) {
        HashSet<T> expectedInternal = new HashSet<T>(expected);
        for (T value : actual) {
            if (expectedInternal.contains(value)) {
                expectedInternal.remove(value);
                continue;
            }
            return String.format("Actual value %s is not from expected set of values %s", value, Client9.setToString(expected));
        }
        if (!expectedInternal.isEmpty()) {
            return String.format("Missing values %s from expected set %s", Client9.setToString(expectedInternal), Client9.setToString(expected));
        }
        return null;
    }

    private static <T> String setToString(Set<T> set) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (T item : set) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(item.toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

