/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.common;

import com.sun.ts.lib.util.TestUtil;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JSONP_Util {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16 = Charset.forName("UTF-16");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    public static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    public static final String FOO_CONFIG = "com.sun.ts.tests.jsonp.common.FOO_CONFIG";
    private static int parseErrs = 0;
    public static final boolean INTEGRAL = true;
    public static final boolean NON_INTEGRAL = false;
    public static final String JSONARRAYFOOBAR = "[\"foo\",\"bar\"]";
    public static final String JSONOBJECTFOOBAR = "{\"foo\":\"bar\"}";
    public static final String EXPECTED_SAMPLEJSONOBJECT_TEXT = "{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}";
    public static final String EXPECTED_SAMPLEJSONARRAY_TEXT = "[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpContentsOfResource(String resource) {
        TestUtil.logMsg((String)("Dumping contents of Resource file: " + resource));
        BufferedReader reader = null;
        try {
            String thisLine;
            InputStream iStream = JSONP_Util.class.getResourceAsStream("/" + resource);
            if (iStream == null) {
                TestUtil.logErr((String)("dumpContentsOfResource: no resource found in classpath or archive named " + resource));
                return;
            }
            reader = new BufferedReader(new InputStreamReader(iStream));
            while ((thisLine = reader.readLine()) != null) {
                TestUtil.logMsg((String)thisLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("exception closing stream: " + String.valueOf(e)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpFile(String file) {
        TestUtil.logMsg((String)("Dumping contents of file: " + file));
        BufferedReader reader = null;
        try {
            String thisLine;
            FileInputStream fis = new FileInputStream(file);
            if (fis == null) {
                TestUtil.logErr((String)("dumpFile: no file found named " + file));
                return;
            }
            reader = new BufferedReader(new InputStreamReader(fis));
            while ((thisLine = reader.readLine()) != null) {
                TestUtil.logMsg((String)thisLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("exception closing stream: " + String.valueOf(e)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentsOfResourceAsString(String resource) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String thisLine;
            InputStream iStream = JSONP_Util.class.getResourceAsStream("/" + resource);
            if (iStream == null) {
                TestUtil.logErr((String)("dumpContentsOfResource: no resource found in classpath or archive named " + resource));
                String string = null;
                return string;
            }
            reader = new BufferedReader(new InputStreamReader(iStream));
            while ((thisLine = reader.readLine()) != null) {
                sb.append(thisLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("exception closing stream: " + String.valueOf(e)));
                }
            }
        }
        return sb.toString();
    }

    public static Reader getReaderFromResource(String resource) {
        InputStreamReader reader = null;
        try {
            InputStream iStream = JSONP_Util.class.getResourceAsStream("/" + resource);
            if (iStream == null) {
                TestUtil.logErr((String)("getReaderFromResource: no resource found in classpath or archive named " + resource));
            } else {
                reader = new InputStreamReader(iStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reader;
    }

    public static Reader getReaderFromString(String contents) {
        InputStreamReader reader = null;
        try {
            ByteArrayInputStream iStream = new ByteArrayInputStream(contents.getBytes(UTF_8));
            if (iStream == null) {
                TestUtil.logErr((String)"getReaderFromString: no input stream");
            } else {
                reader = new InputStreamReader(iStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reader;
    }

    public static InputStream getInputStreamFromResource(String resource) {
        InputStream iStream = null;
        try {
            iStream = JSONP_Util.class.getResourceAsStream("/" + resource);
            if (iStream == null) {
                TestUtil.logErr((String)("getInputStreamFromResource: no resource found in classpath or archive named " + resource));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iStream;
    }

    public static InputStream getInputStreamFromString(String contents) {
        ByteArrayInputStream iStream = null;
        try {
            iStream = new ByteArrayInputStream(contents.getBytes(UTF_8));
            if (iStream == null) {
                TestUtil.logErr((String)"getInputStreamFromString: no input stream");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iStream;
    }

    public static InputStream getInputStreamFromOutputStream(ByteArrayOutputStream baos) {
        ByteArrayInputStream iStream = null;
        try {
            iStream = new ByteArrayInputStream(baos.toByteArray());
            if (iStream == null) {
                TestUtil.logErr((String)"getInputStreamFromOutputStream: no input stream");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iStream;
    }

    public static String removeWhitespace(String text) {
        StringReader reader = new StringReader(text);
        StringWriter writer = new StringWriter();
        try {
            int c;
            boolean quotedString = false;
            boolean backslash = false;
            while ((c = reader.read()) != -1) {
                if (!quotedString && Character.isWhitespace(c)) continue;
                writer.write(c);
                if (c == 34) {
                    if (!backslash) {
                        quotedString = !quotedString;
                    }
                    backslash = false;
                    continue;
                }
                if (c != 92) continue;
                backslash = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public static JsonNumber createJsonNumber(double val) {
        JsonArray array = Json.createArrayBuilder().add(val).build();
        return array.getJsonNumber(0);
    }

    public static JsonNumber createJsonNumber(long val) {
        JsonArray array = Json.createArrayBuilder().add(val).build();
        return array.getJsonNumber(0);
    }

    public static JsonNumber createJsonNumber(int val) {
        JsonArray array = Json.createArrayBuilder().add(val).build();
        return array.getJsonNumber(0);
    }

    public static JsonNumber createJsonNumber(BigDecimal val) {
        JsonArray array = Json.createArrayBuilder().add(val).build();
        return array.getJsonNumber(0);
    }

    public static JsonNumber createJsonNumber(BigInteger val) {
        JsonArray array = Json.createArrayBuilder().add(val).build();
        return array.getJsonNumber(0);
    }

    public static JsonString createJsonString(String val) {
        JsonArray array = Json.createArrayBuilder().add(val).build();
        return array.getJsonString(0);
    }

    public static void dumpJsonString(JsonString value) {
        TestUtil.logMsg((String)("dumpJsonString->" + JSONP_Util.toStringJsonString(value)));
    }

    public static void dumpJsonArray(JsonArray value) {
        TestUtil.logMsg((String)("dumpJsonArray->" + JSONP_Util.toStringJsonArray(value)));
    }

    public static void dumpJsonObject(JsonObject value) {
        TestUtil.logMsg((String)("dumpJsonObject->" + JSONP_Util.toStringJsonObject(value)));
    }

    public static void dumpJsonConstant(JsonValue value) {
        TestUtil.logMsg((String)("dumpJsonConstant->" + JSONP_Util.toStringJsonConstant(value)));
    }

    public static void dumpJsonNumber(JsonNumber value) {
        TestUtil.logMsg((String)("dumpJsonNumber->" + JSONP_Util.toStringJsonNumber(value)));
    }

    public static void dumpJsonValue(JsonValue value) {
        if (value instanceof JsonNumber) {
            JSONP_Util.dumpJsonNumber((JsonNumber)value);
        } else if (value instanceof JsonString) {
            JSONP_Util.dumpJsonString((JsonString)value);
        } else if (value instanceof JsonArray) {
            JSONP_Util.dumpJsonArray((JsonArray)value);
        } else if (value instanceof JsonObject) {
            JSONP_Util.dumpJsonObject((JsonObject)value);
        } else {
            JSONP_Util.dumpJsonConstant(value);
        }
    }

    public static String toStringJsonString(JsonString value) {
        if (value == null) {
            return "JsonString is null";
        }
        return "\"" + value.getString() + "\"";
    }

    public static String toStringJsonArray(JsonArray value) {
        if (value == null) {
            return "JsonArray is null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator iter = value.iterator();
        String comma = "";
        while (iter.hasNext()) {
            sb.append(comma + JSONP_Util.toStringJsonValue((JsonValue)iter.next()));
            if (!comma.equals("")) continue;
            comma = ",";
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toStringJsonObject(JsonObject value) {
        if (value == null) {
            return "JsonObject is null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String comma = "";
        for (Map.Entry entry : value.entrySet()) {
            sb.append(comma + "\"" + (String)entry.getKey() + "\":" + JSONP_Util.toStringJsonValue((JsonValue)entry.getValue()));
            if (!comma.equals("")) continue;
            comma = ",";
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toStringJsonConstant(JsonValue value) {
        if (value == null) {
            return "JsonValue is null";
        }
        if (value == JsonValue.FALSE) {
            return "false";
        }
        if (value == JsonValue.TRUE) {
            return "true";
        }
        if (value == JsonValue.NULL) {
            return "null";
        }
        return "UNKNOWN";
    }

    public static String toStringJsonNumber(JsonNumber value) {
        if (value == null) {
            return "JsonNumber is null";
        }
        if (value.isIntegral()) {
            return "" + value.longValue();
        }
        return String.valueOf(value.bigDecimalValue());
    }

    public static String toStringJsonValue(JsonValue value) {
        if (value instanceof JsonNumber) {
            return JSONP_Util.toStringJsonNumber((JsonNumber)value);
        }
        if (value instanceof JsonString) {
            return JSONP_Util.toStringJsonString((JsonString)value);
        }
        if (value instanceof JsonArray) {
            return JSONP_Util.toStringJsonArray((JsonArray)value);
        }
        if (value instanceof JsonObject) {
            return JSONP_Util.toStringJsonObject((JsonObject)value);
        }
        return JSONP_Util.toStringJsonConstant(value);
    }

    public static void dumpSet(Set<String> set, String msg) {
        TestUtil.logMsg((String)"*** Beg: Dumping List contents ***");
        if (msg != null) {
            TestUtil.logMsg((String)("*** Message: " + msg));
        }
        Iterator<String> iterator = set.iterator();
        TestUtil.logMsg((String)"Set: (");
        while (iterator.hasNext()) {
            TestUtil.logMsg((String)iterator.next());
        }
        TestUtil.logMsg((String)")");
        TestUtil.logMsg((String)"*** End: Dumping Set contents ***");
    }

    public static void dumpSet(Set<String> set) {
        JSONP_Util.dumpSet(set, null);
    }

    public static String toStringSet(Set<String> set) {
        Iterator<String> iter = set.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append("Set: (");
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean assertEqualsSet(Set<String> expSet, Set<String> actSet) {
        if (actSet.equals(expSet)) {
            TestUtil.logMsg((String)"Sets are equal - match (Success)");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringSet(expSet)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringSet(actSet)));
            return true;
        }
        TestUtil.logMsg((String)"Sets are not equal - mismatch (Failure)");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringSet(expSet)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringSet(actSet)));
        return false;
    }

    public static void dumpMap(Map<String, JsonValue> map, String msg) {
        TestUtil.logMsg((String)"*** Beg: Dumping Map contents ***");
        if (msg != null) {
            TestUtil.logMsg((String)("*** Message: " + msg));
        }
        TestUtil.logMsg((String)"Map: {");
        for (Map.Entry<String, JsonValue> entry : map.entrySet()) {
            TestUtil.logMsg((String)("\"" + entry.getKey() + "\":" + JSONP_Util.toStringJsonValue(entry.getValue())));
        }
        TestUtil.logMsg((String)"}");
        TestUtil.logMsg((String)"*** End: Dumping Map contents ***");
    }

    public static void dumpMap(Map<String, JsonValue> map) {
        JSONP_Util.dumpMap(map, null);
    }

    public static String toStringMap(Map<String, JsonValue> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("Map: {");
        String comma = "";
        for (Map.Entry<String, JsonValue> entry : map.entrySet()) {
            sb.append(comma + "\"" + entry.getKey() + "\":" + JSONP_Util.toStringJsonValue(entry.getValue()));
            if (!comma.equals("")) continue;
            comma = ",";
        }
        sb.append("}");
        return sb.toString();
    }

    public static boolean assertEqualsMap(Map<String, JsonValue> expMap, Map<String, JsonValue> actMap) {
        if (actMap.equals(expMap)) {
            TestUtil.logMsg((String)"Maps are equal - match (Success)");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringMap(expMap)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringMap(actMap)));
            return true;
        }
        TestUtil.logMsg((String)"Maps are not equal - mismatch (Failure)");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringMap(expMap)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringMap(actMap)));
        return false;
    }

    public static boolean assertEqualsMap2(Map<String, JsonValue> expMap, Map<String, JsonValue> actMap) {
        TestUtil.logMsg((String)"*** Comparing Map expMap and Map actMap for equality ***");
        TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringMap(expMap)));
        TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringMap(actMap)));
        TestUtil.logMsg((String)"Map expMap size should equal Map actMap size");
        if (expMap.size() != actMap.size()) {
            TestUtil.logErr((String)("Map sizes are not equal: expMap size " + expMap.size() + ", actMap size " + actMap.size()));
            return false;
        }
        TestUtil.logMsg((String)("Map sizes are equal with size of " + expMap.size()));
        for (Map.Entry<String, JsonValue> entry : expMap.entrySet()) {
            String key = entry.getKey();
            if (actMap.containsKey(key)) {
                if (expMap.get(key) == null || actMap.get(key) == null || expMap.get(key).equals((Object)actMap.get(key))) continue;
                TestUtil.logErr((String)("key=" + key + ", expMap value " + String.valueOf(expMap.get(key)) + " does not equal actMap value " + String.valueOf(actMap.get(key))));
                return false;
            }
            TestUtil.logErr((String)("actMap does not contain key " + key));
            return false;
        }
        TestUtil.logMsg((String)"Maps expMap and actMap are equal.");
        return true;
    }

    public static void dumpList(List<JsonValue> list, String msg) {
        TestUtil.logMsg((String)"*** Beg: Dumping List contents ***");
        if (msg != null) {
            TestUtil.logMsg((String)("*** Message: " + msg));
        }
        Iterator<JsonValue> iter = list.iterator();
        TestUtil.logMsg((String)"List: [");
        while (iter.hasNext()) {
            TestUtil.logMsg((String)JSONP_Util.toStringJsonValue(iter.next()));
        }
        TestUtil.logMsg((String)"]");
        TestUtil.logMsg((String)"*** End: Dumping List contents ***");
    }

    public static void dumpList(List<JsonValue> list) {
        JSONP_Util.dumpList(list, null);
    }

    public static String toStringList(List<JsonValue> list) {
        Iterator<JsonValue> iter = list.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append("List: [");
        String comma = "";
        while (iter.hasNext()) {
            sb.append(comma + JSONP_Util.toStringJsonValue(iter.next()));
            if (!comma.equals("")) continue;
            comma = ",";
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean assertEqualsList(List<JsonValue> expList, List<JsonValue> actList) {
        if (actList.equals(expList)) {
            TestUtil.logMsg((String)"Lists are equal - match (Success)");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringList(expList)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringList(actList)));
            return true;
        }
        TestUtil.logMsg((String)"Lists are not equal - mismatch (Failure)");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringList(expList)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringList(actList)));
        return false;
    }

    public static boolean assertEqualsList2(List<JsonValue> expList, List<JsonValue> actList) {
        TestUtil.logMsg((String)"*** Comparing contents of List expList and List actList for equality ***");
        TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringList(expList)));
        TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringList(actList)));
        TestUtil.logMsg((String)"List expList size should equal List actList size");
        if (expList.size() != actList.size()) {
            TestUtil.logErr((String)("List sizes are not equal: expList size " + expList.size() + ", actList size " + actList.size()));
            return false;
        }
        TestUtil.logMsg((String)"Compare Lists (all elements should MATCH)");
        for (int i = 0; i < expList.size(); ++i) {
            if (!expList.get(i).equals((Object)actList.get(i))) {
                TestUtil.logErr((String)("expList element " + i + " does not match actList element " + i));
                TestUtil.logErr((String)("expList[" + i + "]=" + String.valueOf(expList.get(i))));
                TestUtil.logErr((String)("actList[" + i + "]=" + String.valueOf(actList.get(i))));
                return false;
            }
            TestUtil.logMsg((String)("expList element " + i + " matches actList element " + i));
        }
        TestUtil.logMsg((String)"Lists are equal (Success)");
        return true;
    }

    public static void dumpIterator(Iterator<JsonValue> iterator, String msg) {
        TestUtil.logMsg((String)"*** Beg: Dumping Iterator contents ***");
        if (msg != null) {
            TestUtil.logMsg((String)("*** Message: " + msg));
        }
        TestUtil.logMsg((String)"Iter: [");
        while (iterator.hasNext()) {
            TestUtil.logMsg((String)JSONP_Util.toStringJsonValue(iterator.next()));
        }
        TestUtil.logMsg((String)"]");
        TestUtil.logMsg((String)"*** End: Dumping Iterator contents ***");
    }

    public static void dumpIterator(Iterator<JsonValue> iterator) {
        JSONP_Util.dumpIterator(iterator, null);
    }

    public static String toStringIterator(Iterator<JsonValue> iter) {
        StringBuilder sb = new StringBuilder();
        sb.append("Iterator: [");
        while (iter.hasNext()) {
            sb.append(JSONP_Util.toStringJsonValue(iter.next()));
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean assertEqualsIterator(Iterator<JsonValue> expIt, Iterator<JsonValue> actIt) {
        boolean pass = true;
        TestUtil.logMsg((String)"*** Comparing contents of Iterator expIt and Iterator actIt for equality ***");
        int i = 0;
        while (expIt.hasNext()) {
            JsonValue value2;
            if (!actIt.hasNext()) {
                TestUtil.logErr((String)"Iterator expIt contains more elements than Iterator actIt");
                return false;
            }
            ++i;
            JsonValue value1 = expIt.next();
            if (JSONP_Util.assertEqualsJsonValues(value1, value2 = actIt.next())) {
                TestUtil.logMsg((String)("Iterator expIt element  " + i + " matches Iterator actIt element " + i));
                continue;
            }
            TestUtil.logErr((String)("Iterator expIt element " + i + " does not match Iterator actIt element " + i));
            pass = false;
        }
        if (actIt.hasNext()) {
            TestUtil.logErr((String)"Iterator actIt contains more elements than Iterator expIt");
            return false;
        }
        if (pass) {
            TestUtil.logMsg((String)"Iterators are equal (Success)");
        } else {
            TestUtil.logMsg((String)"Iterators are not equal (Failure)");
        }
        return pass;
    }

    public static boolean assertEqualsEmptyArrayList(List<JsonValue> actual) {
        if (actual.isEmpty()) {
            TestUtil.logMsg((String)"Array List is empty - expected");
            return true;
        }
        TestUtil.logErr((String)"Array List is not empty - unexpected");
        return false;
    }

    public static boolean assertEqualsEmptyObjectMap(Map<String, JsonValue> actual) {
        if (actual.isEmpty()) {
            TestUtil.logMsg((String)"Object Map is empty - expected");
            return true;
        }
        TestUtil.logErr((String)"Object Map is not empty - unexpected");
        return false;
    }

    public static boolean assertEqualsEmptyIterator(Iterator<JsonValue> actual) {
        if (!actual.hasNext()) {
            TestUtil.logMsg((String)"Iterator is empty - expected");
            return true;
        }
        TestUtil.logErr((String)"Iterator is not empty - unexpected");
        return false;
    }

    public static boolean assertEqualsJsonText(String expected, String actual) {
        if (actual.equals(expected)) {
            TestUtil.logMsg((String)"JSON text match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"JSON text mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEqualsJsonArrays(JsonArray expected, JsonArray actual) {
        if (actual.equals((Object)expected)) {
            TestUtil.logMsg((String)"JsonArray match");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringJsonArray(expected)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringJsonArray(actual)));
            return true;
        }
        TestUtil.logErr((String)"JsonArray mismatch");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringJsonArray(expected)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringJsonArray(actual)));
        return false;
    }

    public static boolean assertEqualsJsonObjects(JsonObject expected, JsonObject actual) {
        if (actual.equals((Object)expected)) {
            TestUtil.logMsg((String)"JsonObject match");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringJsonObject(expected)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringJsonObject(actual)));
            return true;
        }
        TestUtil.logErr((String)"JsonObject mismatch");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringJsonObject(expected)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringJsonObject(actual)));
        return false;
    }

    public static boolean assertEqualsJsonNumbers(JsonNumber expected, JsonNumber actual) {
        boolean pass = true;
        if (actual.equals((Object)expected)) {
            TestUtil.logMsg((String)"JsonNumber match");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringJsonNumber(expected)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringJsonNumber(actual)));
            return true;
        }
        TestUtil.logErr((String)"JsonNumber mismatch");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringJsonNumber(expected)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringJsonNumber(actual)));
        return false;
    }

    public static boolean assertEqualsJsonStrings(JsonString expected, JsonString actual) {
        boolean pass = true;
        if (actual.equals((Object)expected)) {
            TestUtil.logMsg((String)"JsonString match");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringJsonString(expected)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringJsonString(actual)));
            return true;
        }
        TestUtil.logErr((String)"JsonString mismatch");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringJsonString(expected)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringJsonString(actual)));
        return false;
    }

    public static boolean assertEqualsJsonValues(JsonValue expected, JsonValue actual) {
        boolean pass = true;
        if (expected instanceof JsonNumber) {
            if (!(actual instanceof JsonNumber)) {
                TestUtil.logErr((String)"expected type does not match actual type");
                TestUtil.logErr((String)("expected=" + JSONP_Util.toStringJsonValue(expected)));
                TestUtil.logErr((String)("actual=  " + JSONP_Util.toStringJsonValue(actual)));
                pass = false;
            } else {
                pass = JSONP_Util.assertEqualsJsonNumbers((JsonNumber)expected, (JsonNumber)actual);
            }
        } else if (expected instanceof JsonString) {
            if (!(actual instanceof JsonString)) {
                TestUtil.logErr((String)"expected type does not match actual type");
                TestUtil.logErr((String)("expected=" + JSONP_Util.toStringJsonValue(expected)));
                TestUtil.logErr((String)("actual=  " + JSONP_Util.toStringJsonValue(actual)));
                pass = false;
            } else {
                pass = JSONP_Util.assertEqualsJsonStrings((JsonString)expected, (JsonString)actual);
            }
        } else if (expected instanceof JsonArray) {
            if (!(actual instanceof JsonArray)) {
                TestUtil.logErr((String)"expected type does not match actual type");
                TestUtil.logErr((String)("expected=" + JSONP_Util.toStringJsonValue(expected)));
                TestUtil.logErr((String)("actual=  " + JSONP_Util.toStringJsonValue(actual)));
                pass = false;
            } else {
                pass = JSONP_Util.assertEqualsJsonArrays((JsonArray)expected, (JsonArray)actual);
            }
        } else if (expected instanceof JsonObject) {
            if (!(actual instanceof JsonObject)) {
                TestUtil.logErr((String)"expected type does not match actual type");
                TestUtil.logErr((String)("expected=" + JSONP_Util.toStringJsonValue(expected)));
                TestUtil.logErr((String)("actual=  " + JSONP_Util.toStringJsonValue(actual)));
                pass = false;
            } else {
                pass = JSONP_Util.assertEqualsJsonObjects((JsonObject)expected, (JsonObject)actual);
            }
        } else if (expected.equals((Object)actual)) {
            TestUtil.logMsg((String)"expected matches actual");
            TestUtil.logMsg((String)("expected=" + JSONP_Util.toStringJsonValue(expected)));
            TestUtil.logMsg((String)("actual=  " + JSONP_Util.toStringJsonValue(actual)));
        } else {
            TestUtil.logErr((String)"expected does not match actual");
            TestUtil.logErr((String)("expected=" + JSONP_Util.toStringJsonValue(expected)));
            TestUtil.logErr((String)("actual=  " + JSONP_Util.toStringJsonValue(actual)));
            pass = false;
        }
        return pass;
    }

    public static boolean assertEqualsJsonValueType(JsonValue.ValueType expected, JsonValue.ValueType actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"JsonValue.ValueType match");
            TestUtil.logMsg((String)("Expected: " + String.valueOf(expected)));
            TestUtil.logMsg((String)("Actual:   " + String.valueOf(actual)));
            return true;
        }
        TestUtil.logErr((String)"JsonValue.ValueType mismatch");
        TestUtil.logErr((String)("Expected: " + String.valueOf(expected)));
        TestUtil.logErr((String)("Actual:   " + String.valueOf(actual)));
        return false;
    }

    public static boolean assertEqualsJsonNumberType(boolean expected, boolean actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"Json NumberType match");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringJsonNumberType(expected)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringJsonNumberType(actual)));
            return true;
        }
        TestUtil.logErr((String)"Json NumberType mismatch");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringJsonNumberType(expected)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringJsonNumberType(actual)));
        return false;
    }

    public static boolean assertEqualsJsonNumberTypes(boolean[] expected, boolean actual) {
        for (int i = 0; i < expected.length; ++i) {
            if (actual != expected[i]) continue;
            TestUtil.logMsg((String)"Json NumberType match");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringJsonNumberType(expected[i])));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringJsonNumberType(actual)));
            return true;
        }
        TestUtil.logErr((String)"Json NumberType mismatch");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringJsonNumberTypes(expected)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringJsonNumberType(actual)));
        return false;
    }

    public static String toStringJsonNumberType(boolean numberType) {
        if (numberType) {
            return "INTEGRAL";
        }
        return "NON_INTEGRAL";
    }

    public static String toStringJsonNumberTypes(boolean[] expected) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expected.length; ++i) {
            sb.append(JSONP_Util.toStringJsonNumberType(expected[i]));
            if (i + 1 >= expected.length) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    public static boolean assertEquals(Object expected, Object actual) {
        if (actual.equals(expected)) {
            TestUtil.logMsg((String)"Object match");
            TestUtil.logMsg((String)("Expected: " + String.valueOf(expected)));
            TestUtil.logMsg((String)("Actual:   " + String.valueOf(actual)));
            return true;
        }
        TestUtil.logErr((String)"Object mismatch");
        TestUtil.logErr((String)("Expected: " + String.valueOf(expected)));
        TestUtil.logErr((String)("Actual:   " + String.valueOf(actual)));
        return false;
    }

    public static boolean assertEquals(boolean expected, boolean actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"boolean match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"boolean mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEquals(short expected, short actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"short match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"short mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEquals(int expected, int actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"int match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"int mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEquals(long expected, long actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"long match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"long mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEquals(float expected, float actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"float match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"float mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEquals(double expected, double actual) {
        if (actual == expected) {
            TestUtil.logMsg((String)"double match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"double mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEquals(BigDecimal expected, BigDecimal actual) {
        if (actual.equals(expected)) {
            TestUtil.logMsg((String)"BigDecimal match");
            TestUtil.logMsg((String)("Expected: " + String.valueOf(expected)));
            TestUtil.logMsg((String)("Actual:   " + String.valueOf(actual)));
            return true;
        }
        TestUtil.logErr((String)"BigDecimal mismatch");
        TestUtil.logErr((String)("Expected: " + String.valueOf(expected)));
        TestUtil.logErr((String)("Actual:   " + String.valueOf(actual)));
        return false;
    }

    public static boolean assertEquals(BigInteger expected, BigInteger actual) {
        if (actual.equals(expected)) {
            TestUtil.logMsg((String)"BigInteger match");
            TestUtil.logMsg((String)("Expected: " + String.valueOf(expected)));
            TestUtil.logMsg((String)("Actual:   " + String.valueOf(actual)));
            return true;
        }
        TestUtil.logErr((String)"BigInteger mismatch");
        TestUtil.logErr((String)("Expected: " + String.valueOf(expected)));
        TestUtil.logErr((String)("Actual:   " + String.valueOf(actual)));
        return false;
    }

    public static boolean assertEquals(String expected, String actual) {
        if (actual.equals(expected)) {
            TestUtil.logMsg((String)"String match");
            TestUtil.logMsg((String)("Expected: " + expected));
            TestUtil.logMsg((String)("Actual:   " + actual));
            return true;
        }
        TestUtil.logErr((String)"String mismatch");
        TestUtil.logErr((String)("Expected: " + expected));
        TestUtil.logErr((String)("Actual:   " + actual));
        return false;
    }

    public static boolean assertEquals(JsonValue expected, JsonValue actual) {
        if (actual.equals((Object)expected)) {
            TestUtil.logMsg((String)"JsonValue match");
            TestUtil.logMsg((String)("Expected: " + JSONP_Util.toStringJsonValue(expected)));
            TestUtil.logMsg((String)("Actual:   " + JSONP_Util.toStringJsonValue(actual)));
            return true;
        }
        TestUtil.logErr((String)"JsonValue mismatch");
        TestUtil.logErr((String)("Expected: " + JSONP_Util.toStringJsonValue(expected)));
        TestUtil.logErr((String)("Actual:   " + JSONP_Util.toStringJsonValue(actual)));
        return false;
    }

    public static String getNumberTypeString(boolean numberType) {
        if (numberType) {
            return "INTEGRAL";
        }
        return "NON_INTEGRAL";
    }

    public static boolean getNumberType(String numberType) {
        return numberType.equals("INTEGRAL");
    }

    public static String getValueTypeString(JsonValue.ValueType valueType) {
        switch (valueType) {
            case ARRAY: {
                return "ARRAY";
            }
            case FALSE: {
                return "FALSE";
            }
            case NULL: {
                return "NULL";
            }
            case NUMBER: {
                return "NUMBER";
            }
            case OBJECT: {
                return "OBJECT";
            }
            case STRING: {
                return "STRING";
            }
            case TRUE: {
                return "TRUE";
            }
        }
        return null;
    }

    public static JsonValue.ValueType getValueType(String valueType) {
        if (valueType.equals("ARRAY")) {
            return JsonValue.ValueType.ARRAY;
        }
        if (valueType.equals("FALSE")) {
            return JsonValue.ValueType.FALSE;
        }
        if (valueType.equals("NULL")) {
            return JsonValue.ValueType.NULL;
        }
        if (valueType.equals("NUMBER")) {
            return JsonValue.ValueType.NUMBER;
        }
        if (valueType.equals("OBJECT")) {
            return JsonValue.ValueType.OBJECT;
        }
        if (valueType.equals("STRING")) {
            return JsonValue.ValueType.STRING;
        }
        if (valueType.equals("TRUE")) {
            return JsonValue.ValueType.TRUE;
        }
        return null;
    }

    public static void dumpEventType(JsonParser.Event eventType) {
        TestUtil.logMsg((String)("JsonParser.Event=" + String.valueOf(eventType)));
    }

    public static String getEventTypeString(JsonParser.Event eventType) {
        switch (eventType) {
            case START_ARRAY: {
                return "START_ARRAY";
            }
            case START_OBJECT: {
                return "START_OBJECT";
            }
            case KEY_NAME: {
                return "KEY_NAME";
            }
            case VALUE_STRING: {
                return "VALUE_STRING";
            }
            case VALUE_NUMBER: {
                return "VALUE_NUMBER";
            }
            case VALUE_TRUE: {
                return "VALUE_TRUE";
            }
            case VALUE_FALSE: {
                return "VALUE_FALSE";
            }
            case VALUE_NULL: {
                return "VALUE_NULL";
            }
            case END_OBJECT: {
                return "END_OBJECT";
            }
            case END_ARRAY: {
                return "END_ARRAY";
            }
        }
        return null;
    }

    public static JsonParser.Event getEventType(String eventType) {
        if (eventType.equals("START_ARRAY")) {
            return JsonParser.Event.START_ARRAY;
        }
        if (eventType.equals("START_OBJECT")) {
            return JsonParser.Event.START_OBJECT;
        }
        if (eventType.equals("KEY_NAME")) {
            return JsonParser.Event.KEY_NAME;
        }
        if (eventType.equals("VALUE_STRING")) {
            return JsonParser.Event.VALUE_STRING;
        }
        if (eventType.equals("VALUE_NUMBER")) {
            return JsonParser.Event.VALUE_NUMBER;
        }
        if (eventType.equals("VALUE_TRUE")) {
            return JsonParser.Event.VALUE_TRUE;
        }
        if (eventType.equals("VALUE_FALSE")) {
            return JsonParser.Event.VALUE_FALSE;
        }
        if (eventType.equals("VALUE_NULL")) {
            return JsonParser.Event.VALUE_NULL;
        }
        if (eventType.equals("END_OBJECT")) {
            return JsonParser.Event.END_OBJECT;
        }
        if (eventType.equals("END_ARRAY")) {
            return JsonParser.Event.END_ARRAY;
        }
        return null;
    }

    public static String getConfigName(String configValue) {
        if (configValue.equals("jakarta.json.stream.JsonGenerator.prettyPrinting")) {
            return "JsonGenerator.PRETTY_PRINTING";
        }
        if (configValue.equals(FOO_CONFIG)) {
            return "JSONP_Util.FOO_CONFIG";
        }
        return null;
    }

    public static String getConfigValue(String configProp) {
        if (configProp.equals("JsonGenerator.PRETTY_PRINING")) {
            return "jakarta.json.stream.JsonGenerator.prettyPrinting";
        }
        if (configProp.equals("JSONP_Util.FOO_CONFIG")) {
            return FOO_CONFIG;
        }
        return null;
    }

    public static void dumpConfigMap(Map<String, ?> map, String msg) {
        TestUtil.logMsg((String)"*** Beg: Dumping Config Map contents ***");
        if (msg != null) {
            TestUtil.logMsg((String)("*** Message: " + msg));
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            TestUtil.logMsg((String)("\"" + entry.getKey() + "\":" + String.valueOf(entry.getValue())));
        }
        TestUtil.logMsg((String)"*** End: Dumping Config Map contents ***");
    }

    public static void dumpConfigMap(Map<String, ?> map) {
        JSONP_Util.dumpConfigMap(map, null);
    }

    public static boolean doConfigCheck(Map<String, ?> config, int expectedSize) {
        return JSONP_Util.doConfigCheck(config, expectedSize, null);
    }

    public static boolean doConfigCheck(Map<String, ?> config, int expectedSize, String[] expectedProps) {
        boolean pass = true;
        JSONP_Util.dumpConfigMap(config);
        TestUtil.logMsg((String)"Checking factory configuration property size");
        if (config.size() != expectedSize) {
            TestUtil.logErr((String)("Expecting no of properties=" + expectedSize + ", got=" + config.size()));
            pass = false;
        } else {
            TestUtil.logMsg((String)("Expecting no of properties=" + expectedSize + ", got=" + config.size()));
        }
        if (expectedSize != 0 && expectedProps != null) {
            TestUtil.logMsg((String)"Checking factory configuration property name and value");
            for (int i = 0; i < expectedProps.length; ++i) {
                if (config.containsKey(expectedProps[i])) {
                    TestUtil.logMsg((String)("Does contain key: " + expectedProps[i] + " - expected."));
                    if (JSONP_Util.assertEquals((Object)true, config.get(expectedProps[i]))) continue;
                    pass = false;
                    continue;
                }
                TestUtil.logErr((String)("Does not contain key: " + expectedProps[i] + " - unexpected."));
                pass = false;
            }
        }
        return pass;
    }

    public boolean isEmptyConfig(Map<String, ?> config) {
        TestUtil.logMsg((String)"isEmptyConfig");
        return config.isEmpty();
    }

    public static Map<String, ?> getEmptyConfig() {
        TestUtil.logMsg((String)"getEmptyConfig");
        HashMap config = new HashMap();
        return config;
    }

    public static Map<String, ?> getPrettyPrintingConfig() {
        TestUtil.logMsg((String)"getPrettyPrintConfig");
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        TestUtil.logMsg((String)"Added property: JsonGenerator.PRETTY_PRINTING");
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
        return config;
    }

    public static Map<String, ?> getFooConfig() {
        TestUtil.logMsg((String)"getFooConfig");
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        TestUtil.logMsg((String)"Added property: JSONP_Util.FOO_CONFIG");
        config.put(FOO_CONFIG, true);
        return config;
    }

    public static Map<String, ?> getAllConfig() {
        TestUtil.logMsg((String)"getAllConfig");
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        TestUtil.logMsg((String)"Added property: JsonGenerator.PRETTY_PRINTING");
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
        TestUtil.logMsg((String)"Added property: JSONP_Util.FOO_CONFIG");
        config.put(FOO_CONFIG, true);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject createJsonObjectFromString(String jsonObjData) {
        JsonObject object = null;
        try (JsonReader reader = null;){
            reader = Json.createReader((Reader)new StringReader(jsonObjData));
            object = reader.readObject();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonArray createJsonArrayFromString(String jsonArrData) {
        JsonArray array = null;
        try (JsonReader reader = null;){
            reader = Json.createReader((Reader)new StringReader(jsonArrData));
            array = reader.readArray();
        }
        return array;
    }

    public static void writeJsonObjectFromString(JsonWriter writer, String jsonObjData) {
        try {
            JsonObject jsonObject = JSONP_Util.createJsonObjectFromString(jsonObjData);
            writer.writeObject(jsonObject);
            writer.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + String.valueOf(e)));
        }
    }

    public static void writeJsonArrayFromString(JsonWriter writer, String jsonArrData) {
        try {
            JsonArray jsonArray = JSONP_Util.createJsonArrayFromString(jsonArrData);
            writer.writeArray(jsonArray);
            writer.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + String.valueOf(e)));
        }
    }

    public static void testKeyStringValue(JsonParser parser, String name, String value) {
        String keyvalue;
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_STRING) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_STRING) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        }
        if (!(keyvalue = parser.getString()).equals(value)) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testKeyIntegerValue(JsonParser parser, String name, int value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        int keyvalue = parser.getInt();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testKeyDoubleValue(JsonParser parser, String name, double value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        double keyvalue = parser.getBigDecimal().doubleValue();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testKeyLongValue(JsonParser parser, String name, long value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        long keyvalue = parser.getLong();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testKeyBigDecimalValue(JsonParser parser, String name, BigDecimal value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        BigDecimal keyvalue = parser.getBigDecimal();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + String.valueOf(value) + ", got keyvalue: " + String.valueOf(keyvalue)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + String.valueOf(keyvalue)));
        }
    }

    public static void testKeyTrueValue(JsonParser parser, String name) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_TRUE) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_TRUE) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
    }

    public static void testKeyFalseValue(JsonParser parser, String name) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_FALSE) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_FALSE) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
    }

    public static void testKeyNullValue(JsonParser parser, String name) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.VALUE_NULL) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NULL) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
    }

    public static void testKeyStartObjectValue(JsonParser parser, String name) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.START_OBJECT) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.START_OBJECT) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
    }

    public static void testKeyStartArrayValue(JsonParser parser, String name) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.KEY_NAME) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.KEY_NAME) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyname = parser.getString();
        if (!name.equals(keyname)) {
            TestUtil.logErr((String)("Expected keyname: " + name + ", got keyname: " + keyname));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyname: " + keyname));
        }
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        e = parser.next();
        if (e != JsonParser.Event.START_ARRAY) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.START_ARRAY) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
    }

    public static boolean checkNextParserEvent(JsonParser parser) {
        if (!parser.hasNext()) {
            TestUtil.logErr((String)"no next parser event found - unexpected");
            ++parseErrs;
            return false;
        }
        return true;
    }

    public static JsonParser.Event getNextParserEvent(JsonParser parser) {
        if (parser.hasNext()) {
            return parser.next();
        }
        return null;
    }

    public static JsonParser.Event getNextSpecificParserEvent(JsonParser parser, JsonParser.Event thisEvent) {
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (event != thisEvent) continue;
            return event;
        }
        return null;
    }

    public static void testEventType(JsonParser parser, JsonParser.Event expEvent) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != expEvent) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(expEvent) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
    }

    public static void testStringValue(JsonParser parser, String value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.VALUE_STRING) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_STRING) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        String keyvalue = parser.getString();
        if (!keyvalue.equals(value)) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testIntegerValue(JsonParser parser, int value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        int keyvalue = parser.getInt();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testDoubleValue(JsonParser parser, double value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        double keyvalue = parser.getBigDecimal().doubleValue();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testLongValue(JsonParser parser, long value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        long keyvalue = parser.getLong();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + value + ", got keyvalue: " + keyvalue));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + keyvalue));
        }
    }

    public static void testBigDecimalValue(JsonParser parser, BigDecimal value) {
        if (!JSONP_Util.checkNextParserEvent(parser)) {
            return;
        }
        JsonParser.Event e = parser.next();
        if (e != JsonParser.Event.VALUE_NUMBER) {
            TestUtil.logErr((String)("Expected event: " + JSONP_Util.getEventTypeString(JsonParser.Event.VALUE_NUMBER) + ", got event: " + JSONP_Util.getEventTypeString(e)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected event: " + JSONP_Util.getEventTypeString(e)));
        }
        BigDecimal keyvalue = parser.getBigDecimal();
        if (keyvalue != value) {
            TestUtil.logErr((String)("Expected keyvalue: " + String.valueOf(value) + ", got keyvalue: " + String.valueOf(keyvalue)));
            ++parseErrs;
        } else {
            TestUtil.logMsg((String)("Got expected keyvalue: " + String.valueOf(keyvalue)));
        }
    }

    public static void testTrueValue(JsonParser parser, JsonParser.Event expEvent) {
        JSONP_Util.testEventType(parser, expEvent);
    }

    public static void testFalseValue(JsonParser parser, JsonParser.Event expEvent) {
        JSONP_Util.testEventType(parser, expEvent);
    }

    public static void testNullValue(JsonParser parser, JsonParser.Event expEvent) {
        JSONP_Util.testEventType(parser, expEvent);
    }

    public static void resetParseErrs() {
        parseErrs = 0;
    }

    public static int getParseErrs() {
        return parseErrs;
    }

    public static String convertUnicodeCharToString(char c) {
        return "\\u" + Integer.toHexString(c | 0x10000).substring(1);
    }

    public static boolean isUnicodeControlChar(char c) {
        return c >= '\u0000' && c <= '\u001f' || c == '\u007f' || c >= '\u0080' && c <= '\u009f';
    }

    public static void writeStringToFile(String string, String file, String encoding) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
            out.write(string);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readStringFromFile(String file, String encoding) {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeStringToStream(String string, OutputStream os, String encoding) {
        try {
            OutputStreamWriter out = new OutputStreamWriter(os, encoding);
            out.write(string);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readStringFromStream(InputStream is, String encoding) {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            InputStreamReader isr = new InputStreamReader(is, encoding);
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeStringToFile(String string, String file, Charset charset) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, charset);
            out.write(string);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readStringFromFile(String file, Charset charset) {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeStringToStream(String string, OutputStream os, Charset charset) {
        try {
            OutputStreamWriter out = new OutputStreamWriter(os, charset);
            out.write(string);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readStringFromStream(InputStream is, Charset charset) {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            InputStreamReader isr = new InputStreamReader(is, charset);
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Charset getCharset(String encoding) {
        Charset cs = null;
        try {
            cs = Charset.forName(encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cs;
    }

    public static void dumpLocation(JsonLocation location) {
        if (location != null) {
            TestUtil.logMsg((String)("JsonLocation info: lineNumber=" + location.getLineNumber() + ", columnNumber=" + location.getColumnNumber() + ", streamOffset=" + location.getStreamOffset()));
        } else {
            TestUtil.logMsg((String)"JsonLocation is null - no location info");
        }
    }

    public static void dumpLocation(JsonParser parser) {
        JSONP_Util.dumpLocation(parser.getLocation());
    }

    public static boolean assertEquals(JsonLocation expLoc, JsonLocation actLoc) {
        if (expLoc.getLineNumber() == actLoc.getLineNumber() && expLoc.getColumnNumber() == actLoc.getColumnNumber() && expLoc.getStreamOffset() == actLoc.getStreamOffset()) {
            TestUtil.logMsg((String)"JsonLocations equal - match (Success)");
            TestUtil.logMsg((String)("Expected: JsonLocation info: lineNumber=" + expLoc.getLineNumber() + ", columnNumber=" + expLoc.getColumnNumber() + ", streamOffset=" + expLoc.getStreamOffset()));
            TestUtil.logMsg((String)("Actual:   JsonLocation info: lineNumber=" + actLoc.getLineNumber() + ", columnNumber=" + actLoc.getColumnNumber() + ", streamOffset=" + actLoc.getStreamOffset()));
            return true;
        }
        TestUtil.logErr((String)"JsonLocations not equal - mismatch (Failure)");
        TestUtil.logErr((String)("Expected: JsonLocation info: lineNumber=" + expLoc.getLineNumber() + ", columnNumber=" + expLoc.getColumnNumber() + ", streamOffset=" + expLoc.getStreamOffset()));
        TestUtil.logErr((String)("Actual:   JsonLocation info: lineNumber=" + actLoc.getLineNumber() + ", columnNumber=" + actLoc.getColumnNumber() + ", streamOffset=" + actLoc.getStreamOffset()));
        return false;
    }

    public static void addFileToClassPath(String s) throws Exception {
        JSONP_Util.addFileToClassPath(new File(s));
    }

    public static void addFileToClassPath(File f) throws Exception {
        JSONP_Util.addURLToClassPath(f.toURI().toURL());
    }

    public static void addURLToClassPath(URL url) throws Exception {
        TestUtil.logMsg((String)("addURLToClassPath-> " + url.toString()));
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Class<URLClassLoader> urlClassLoaderClass = URLClassLoader.class;
            Method method = urlClassLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static JsonArray buildJsonArrayFooBar() {
        try {
            JsonArray jsonArray = Json.createArrayBuilder().add("foo").add("bar").build();
            return jsonArray;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + String.valueOf(e)));
            return null;
        }
    }

    public static JsonObject buildJsonObjectFooBar() {
        try {
            JsonObject jsonObject = Json.createObjectBuilder().add("foo", "bar").build();
            return jsonObject;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + String.valueOf(e)));
            return null;
        }
    }

    public static JsonObject createSampleJsonObject() throws Exception {
        JsonObject object = Json.createObjectBuilder().add("firstName", "John").add("lastName", "Smith").add("age", 25).add("elderly", JsonValue.FALSE).add("patriot", JsonValue.TRUE).add("address", Json.createObjectBuilder().add("streetAddress", "21 2nd Street").add("city", "New York").add("state", "NY").add("postalCode", "10021")).add("phoneNumber", Json.createArrayBuilder().add(Json.createObjectBuilder().add("type", "home").add("number", "212 555-1234")).add(Json.createObjectBuilder().add("type", "cell").add("number", "646 555-4567"))).add("objectOfFooBar", Json.createObjectBuilder().add("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).add("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar())).add("arrayOfFooBar", Json.createArrayBuilder().add((JsonValue)JSONP_Util.buildJsonObjectFooBar()).add((JsonValue)JSONP_Util.buildJsonArrayFooBar())).build();
        return object;
    }

    public static JsonObject createSampleJsonObject2() throws Exception {
        JsonObject object = Json.createObjectBuilder().add("firstName", "John").add("lastName", "Smith").add("age", 25).add("elderly", JsonValue.FALSE).add("patriot", JsonValue.TRUE).add("address", Json.createObjectBuilder().add("streetAddress", "21 2nd Street").add("city", "New York").add("state", "NY").add("postalCode", "10021")).add("phoneNumber", Json.createArrayBuilder().add(Json.createObjectBuilder().add("type", "home").add("number", "212 555-1234")).add(Json.createObjectBuilder().add("type", "cell").add("number", "535 444-1234"))).build();
        return object;
    }

    public static JsonArray createSampleJsonArray() throws Exception {
        JsonArray array = Json.createArrayBuilder().add(Json.createObjectBuilder().add("name1", "value1").add("name2", "value2")).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(100).add(200L).add("string").add(BigDecimal.valueOf(123456789L)).add(new BigInteger("123456789")).add(Json.createObjectBuilder().add("name3", "value3").add("name4", "value4")).add(true).add(false).addNull().add(Json.createArrayBuilder().add(2).add(4)).add(Json.createObjectBuilder().add("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).add("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar())).add(Json.createArrayBuilder().add((JsonValue)JSONP_Util.buildJsonObjectFooBar()).add((JsonValue)JSONP_Util.buildJsonArrayFooBar())).build();
        return array;
    }

    public static JsonArray createSampleJsonArray2() throws Exception {
        JsonArray array = Json.createArrayBuilder().add(Json.createObjectBuilder().add("name1", "value1").add("name2", "value2")).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add("string").add(Json.createObjectBuilder().add("name3", "value3").add("name4", "value4")).add(true).add(false).addNull().add(Json.createArrayBuilder().add(1).add(3)).build();
        return array;
    }
}

