/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.pluggability.jsonbprovidertests;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.vehicle.EmptyVehicleRunner;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.jsonb.provider.MyJsonbBuilder;
import com.sun.ts.tests.jsonb.provider.MyJsonbProvider;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.spi.JsonbProvider;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;
import tck.arquillian.protocol.common.TargetVehicle;

@Tags(value={@Tag(value="tck-appclient"), @Tag(value="jsonb"), @Tag(value="platform")})
@ExtendWith(value={ArquillianExtension.class})
public class ClientAppclientTest
extends ServiceEETest {
    private static final System.Logger logger = System.getLogger(ClientAppclientTest.class.getName());
    static final String VEHICLE_ARCHIVE = "jsonprovidertests_appclient_vehicle";
    private static String packagePath = ClientAppclientTest.class.getPackageName().replace(".", "/");
    private static final String providerPackagePath = MyJsonbProvider.class.getPackageName().replace(".", "/");
    private boolean providerJarDeployed = false;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir", "/tmp");
    private static final String MY_JSONBROVIDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbProvider";
    private static final String MY_JSONBBUILDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbBuilder";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @TargetsContainer(value="tck-appclient")
    @OverProtocol(value="appclient")
    @Deployment(name="jsonprovidertests_appclient_vehicle", testable=true)
    public static EnterpriseArchive createAppclientDeployment(@ArquillianResource TestArchiveProcessor archiveProcessor) throws Exception {
        JavaArchive jsonb_alternate_provider_jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonb_alternate_provider.jar")).addClasses(new Class[]{MyJsonbBuilder.class, MyJsonbProvider.class, ClientAppclientTest.class})).addAsResource((Asset)new UrlAsset(MyJsonbProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.bind.spi.JsonbProvider")), "META-INF/services/jakarta.json.bind.spi.JsonbProvider");
        jsonb_alternate_provider_jar.addAsManifestResource((Asset)new StringAsset("Main-Class: " + ClientAppclientTest.class.getName() + "\n"), "MANIFEST.MF");
        JavaArchive jsonbprovidertests_appclient_vehicle_client = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonbprovidertests_appclient_vehicle_client.jar");
        jsonbprovidertests_appclient_vehicle_client.addClasses(new Class[]{VehicleRunnerFactory.class, VehicleRunnable.class, VehicleClient.class, EmptyVehicleRunner.class, EETest.class, EETest.Fault.class, EETest.SetupException.class, ServiceEETest.class, ClientAppclientTest.class});
        URL resURL = ClientAppclientTest.class.getClassLoader().getResource(packagePath + "/appclient_vehicle_client.xml");
        if (resURL != null) {
            jsonbprovidertests_appclient_vehicle_client.addAsManifestResource(resURL, "application-client.xml");
        }
        jsonbprovidertests_appclient_vehicle_client.addAsManifestResource((Asset)new StringAsset("Main-Class: " + ClientAppclientTest.class.getName() + "\n"), "MANIFEST.MF");
        EnterpriseArchive jsonbprovidertests_appclient_vehicle_ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"jsonbprovidertests_appclient_vehicle.ear");
        jsonbprovidertests_appclient_vehicle_ear.addAsModule((Archive)jsonbprovidertests_appclient_vehicle_client);
        jsonbprovidertests_appclient_vehicle_ear.addAsLibrary((Archive)jsonb_alternate_provider_jar);
        jsonbprovidertests_appclient_vehicle_ear.addAsModule((Archive)jsonb_alternate_provider_jar);
        return jsonbprovidertests_appclient_vehicle_ear;
    }

    public void removeProviderJarFromCP() throws Exception {
        if (this.providerJarDeployed) {
            URLClassLoader currentThreadClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader.getParent());
            currentThreadClassLoader.close();
            this.providerJarDeployed = false;
        }
    }

    public void createProviderJar() throws Exception {
        JavaArchive jarArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonb_alternate_provider.jar")).addClasses(new Class[]{MyJsonbBuilder.class, MyJsonbProvider.class})).addAsResource((Asset)new UrlAsset(MyJsonbProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.bind.spi.JsonbProvider")), "META-INF/services/jakarta.json.bind.spi.JsonbProvider");
        ((ZipExporter)jarArchive.as(ZipExporter.class)).exportTo(new File(TEMP_DIR + File.separator + "jsonb_alternate_provider.jar"), true);
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(TEMP_DIR + File.separator + "jsonb_alternate_provider.jar").toURL()}, currentThreadClassLoader);
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        this.providerJarDeployed = true;
    }

    public static void main(String[] args) {
        ClientAppclientTest theTests = new ClientAppclientTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.createProviderJar();
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.removeProviderJarFromCP();
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    @Test
    @TargetVehicle(value="appclient")
    public void jsonbProviderTest1() throws Exception {
        try {
            JsonbProvider provider = JsonbProvider.provider();
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest1 Failed: ", e);
        }
    }

    @Test
    @TargetVehicle(value="appclient")
    public void jsonbProviderTest2() throws Exception {
        boolean pass = true;
        try {
            JsonbProvider provider = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS);
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
            if (providerClass.equals(MY_JSONBROVIDER_CLASS)) {
                logger.log(System.Logger.Level.INFO, "Current provider is my provider - expected.");
            } else {
                logger.log(System.Logger.Level.ERROR, "Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
                Iterator<JsonbProvider> it = loader.iterator();
                ArrayList<JsonbProvider> providers = new ArrayList<JsonbProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                logger.log(System.Logger.Level.INFO, "Providers: " + String.valueOf(providers));
            }
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonbProviderTest2 Failed");
        }
    }

    @Test
    @TargetVehicle(value="appclient")
    public void jsonbProviderTest3() throws Exception {
        try {
            JsonbBuilder builder = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS).create();
            String providerClass = builder.getClass().getName();
            logger.log(System.Logger.Level.INFO, "jsonb builder class=" + providerClass);
            if (!providerClass.equals(MY_JSONBBUILDER_CLASS)) {
                logger.log(System.Logger.Level.ERROR, "Current jsonb builder is not my builder - unexpected.");
                throw new Exception("jsonbProviderTest3 Failed");
            }
            logger.log(System.Logger.Level.INFO, "Current jsonb builder is my builder - expected.");
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest3 Failed: ", e);
        }
    }
}

