/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.genericentity;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.GenericEntity;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest1() throws JAXRSCommonClient.Fault {
        ArrayList list = new ArrayList();
        try {
            new GenericEntity(list, null);
            throw new JAXRSCommonClient.Fault("Test failed; expected exception not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            JAXRSClientIT.logMsg("Expected IllegalArgumentException thrown:", ilex.getMessage());
            return;
        }
    }

    @Test
    public void constructorTest2() throws JAXRSCommonClient.Fault {
        try {
            new GenericEntity(null, String.class.getGenericSuperclass());
            throw new JAXRSCommonClient.Fault("Test failed; expected exception not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            JAXRSClientIT.logMsg("Expected IllegalArgumentException thrown:", ilex.getMessage());
            return;
        }
    }

    @Test
    public void singleArgumentConstructorTest() throws JAXRSCommonClient.Fault {
        try {
            new GenericEntity<Map<String, List<Long>>>(null){};
            throw new JAXRSCommonClient.Fault("Test failed; expected exception not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            JAXRSClientIT.logMsg("Expected IllegalArgumentException thrown:", ilex.getMessage());
            GenericEntity<Map<String, List<Long>>> generic = new GenericEntity<Map<String, List<Long>>>(new HashMap()){};
            Assertions.assertTrue((boolean)generic.getRawType().isAssignableFrom(HashMap.class), (String)(generic.getRawType() + " != " + Map.class));
            JAXRSClientIT.logMsg("GenericEntity<Map<String, List<Long>>> instance created");
            return;
        }
    }

    @Test
    public void constructorWith2ArgsTest() throws JAXRSCommonClient.Fault {
        ArrayList list = new ArrayList();
        Method method = null;
        try {
            method = this.getClass().getMethod("dummyMethod", new Class[0]);
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        GenericEntity generic = new GenericEntity(list, method.getGenericReturnType());
        String str = String.class.getSimpleName();
        Assertions.assertTrue((boolean)generic.getRawType().isAssignableFrom(ArrayList.class), (String)(generic.getRawType() + " != " + List.class));
        Assertions.assertTrue((boolean)generic.getType().toString().contains(str), (String)(generic.getType() + ".contains(" + str + ") != true"));
        JAXRSClientIT.logMsg("GenericEntity<List<String>>(List, Type) instance created");
    }

    @Test
    public void constructorWith1ArgTest() throws JAXRSCommonClient.Fault {
        ArrayList list = new ArrayList();
        GenericEntity<List<String>> generic = new GenericEntity<List<String>>(list){};
        String str = String.class.getSimpleName();
        Assertions.assertTrue((generic.getRawType() == ArrayList.class ? 1 : 0) != 0, (String)(generic.getRawType() + " != " + List.class));
        Assertions.assertTrue((boolean)generic.getType().toString().contains(str), (String)(generic.getType() + ".contains(" + str + ") != true"));
        JAXRSClientIT.logMsg("GenericEntity<List<String>>(List) instance created");
    }

    public List<String> dummyMethod() {
        return null;
    }

    @Test
    public void getEntityTest() throws JAXRSCommonClient.Fault {
        String testName = "EntityTest";
        HashMap map = new HashMap();
        map.put(testName, new LinkedList());
        GenericEntity<Map<String, List<Long>>> ge = new GenericEntity<Map<String, List<Long>>>(map){};
        if (ge.getEntity() != map || !((String)((Map)ge.getEntity()).keySet().iterator().next()).equals(testName)) {
            throw new JAXRSCommonClient.Fault("Entity has not been retrieved");
        }
        JAXRSClientIT.logMsg("Entity has been retrieved");
    }

    @Test
    public void getTypeTest() throws JAXRSCommonClient.Fault {
        Boolean pass = true;
        StringBuffer sb = new StringBuffer();
        ArrayList lists = new ArrayList();
        GenericEntity<List<String>> entitys = new GenericEntity<List<String>>(lists){};
        String types = entitys.getType().toString();
        if (types.equals("java.util.List<java.lang.String>")) {
            sb.append("getType return correctly: ").append(types).append(newline);
        } else {
            pass = false;
            sb.append("getType return incorrectly: ").append(types).append(newline).append("Expecting java.util.List<java.lang.String>.").append(newline);
        }
        ArrayList listi = new ArrayList();
        GenericEntity<List<Integer>> entityi = new GenericEntity<List<Integer>>(listi){};
        String typei = entityi.getType().toString();
        if (typei.equals("java.util.List<java.lang.Integer>")) {
            sb.append("getType return correctly: ").append(types).append(newline);
        } else {
            pass = false;
            sb.append("getType return incorrectly: ").append(typei).append(newline).append("Expecting java.util.List<java.lang.Integer>.").append(newline);
        }
        if (!pass.booleanValue()) {
            throw new JAXRSCommonClient.Fault("At least one assertion falied. " + sb.toString());
        }
        JAXRSClientIT.logMsg("Test passed. ", sb.toString());
    }

    @Test
    public void getRawTypeTest() throws JAXRSCommonClient.Fault {
        Boolean pass = true;
        StringBuffer sb = new StringBuffer();
        ArrayList lists = new ArrayList();
        GenericEntity<List<String>> entitys = new GenericEntity<List<String>>(lists){};
        String types = entitys.getRawType().toString();
        if (types.indexOf("java.util.ArrayList") > -1) {
            sb.append("getType return correctly: ").append(types).append(newline);
        } else {
            pass = false;
            sb.append("getType return incorrectly: ").append(types).append(newline);
            sb.append("Expecting java.util.ArrayList.").append(newline);
        }
        ArrayList listi = new ArrayList();
        GenericEntity<List<Integer>> entityi = new GenericEntity<List<Integer>>(listi){};
        String typei = entityi.getRawType().toString();
        if (typei.indexOf("java.util.ArrayList") > -1) {
            sb.append("getType return correctly: ").append(types).append(newline);
        } else {
            pass = false;
            sb.append("getType return incorrectly: ").append(typei).append(newline);
            sb.append("Expecting java.util.ArrayList.").append(newline);
        }
        if (!pass.booleanValue()) {
            throw new JAXRSCommonClient.Fault("At least one assertion falied. " + sb.toString());
        }
        JAXRSClientIT.logMsg("Test passed.", sb.toString());
    }

    @Test
    public void equalsTest() throws JAXRSCommonClient.Fault {
        TreeSet set = new TreeSet();
        GenericEntity<TreeSet<String>> type1 = new GenericEntity<TreeSet<String>>(set){};
        GenericEntity<TreeSet<String>> type2 = new GenericEntity<TreeSet<String>>(set){};
        GenericEntity<Set<String>> type3 = new GenericEntity<Set<String>>(set){};
        GenericEntity<TreeSet<String>> type4 = new GenericEntity<TreeSet<String>>((TreeSet)new TreeSet<String>(){
            private static final long serialVersionUID = 1L;
        }){};
        Assertions.assertTrue((boolean)type1.equals((Object)type1), (String)"GenericEntity<TreeSet<String>> is not equal itself");
        Assertions.assertTrue((boolean)type2.equals((Object)type2), (String)"GenericEntity<TreeSet<String>> is not equal itself");
        Assertions.assertTrue((boolean)type1.equals((Object)type2), (String)"GenericEntity<TreeSet<String>> is not equal GenericEntity<TreeSet<String>>");
        Assertions.assertTrue((boolean)type2.equals((Object)type1), (String)"GenericEntity<TreeSet<String>> is not equal GenericEntity<TreeSet<String>>");
        Assertions.assertTrue((!type3.equals((Object)type1) ? 1 : 0) != 0, (String)"GenericEntity<Set<String>> is equal GenericEntity<TreeSet<String>>");
        Assertions.assertTrue((boolean)type4.equals((Object)type1), (String)"GenericEntity<TreeSet<String>>(set) is not equal GenericEntity<TreeSet<String>>(otherSet)");
        JAXRSClientIT.logMsg("The tested GenericEntity<TreeSet<String>> instances are equal");
    }

    @Test
    public void hashCodeTest() throws JAXRSCommonClient.Fault {
        TreeSet set = new TreeSet();
        GenericEntity<TreeSet<String>> type1 = new GenericEntity<TreeSet<String>>(set){};
        GenericEntity<TreeSet<String>> type2 = new GenericEntity<TreeSet<String>>(set){};
        GenericEntity<Set<String>> type3 = new GenericEntity<Set<String>>(set){};
        GenericEntity<TreeSet<String>> type4 = new GenericEntity<TreeSet<String>>((TreeSet)new TreeSet<String>(){
            private static final long serialVersionUID = 1L;
        }){};
        Assertions.assertTrue((type1.hashCode() == type1.hashCode() ? 1 : 0) != 0, (String)"HashCode of itself is random");
        Assertions.assertTrue((type2.hashCode() == type2.hashCode() ? 1 : 0) != 0, (String)"HashCode of itself is random");
        Assertions.assertTrue((type1.hashCode() == type2.hashCode() ? 1 : 0) != 0, (String)"Both GenericEntity instances should have the same hashCode");
        Assertions.assertTrue((type1.hashCode() != type3.hashCode() ? 1 : 0) != 0, (String)"GenericEntity<Set<String>>.hashCode()==GenericEntity<TreeSet<String>>.hashCode()");
        Assertions.assertTrue((type4.hashCode() == type1.hashCode() ? 1 : 0) != 0, (String)"GenericEntity<Set<String>>(set).hashCode()!=GenericEntity<TreeSet<String>>(otherSet).hashCode()");
        JAXRSClientIT.logMsg("Both GenericEntity instances have the same hashCode()");
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        TreeSet set = new TreeSet();
        GenericEntity<TreeSet<String>> type1 = new GenericEntity<TreeSet<String>>(set){};
        GenericEntity<TreeSet<String>> type2 = new GenericEntity<TreeSet<String>>(set){};
        GenericEntity<Set<String>> type3 = new GenericEntity<Set<String>>(set){};
        GenericEntity<TreeSet<String>> type4 = new GenericEntity<TreeSet<String>>((TreeSet)new TreeSet<String>(){
            private static final long serialVersionUID = 1L;
        }){};
        Assertions.assertTrue((boolean)type1.toString().equals(type1.toString()), (String)"toString() of itself is random");
        Assertions.assertTrue((boolean)type2.toString().equals(type2.toString()), (String)"toString() of itself is random");
        Assertions.assertTrue((boolean)type1.toString().equals(type2.toString()), (String)"Both GenericEntity instances should have the same toString()");
        Assertions.assertTrue((!type1.toString().equals(type3.toString()) ? 1 : 0) != 0, (String)"GenericEntity<Set<String>>.toString()==GenericEntity<TreeSet<String>>.toString()");
        Assertions.assertTrue((boolean)type4.toString().equals(type1.toString()), (String)"GenericEntity<Set<String>>(set).toString()!=GenericEntity<TreeSet<String>>(otherSet).toString()");
        JAXRSClientIT.logMsg("Both GenericEntity instances have the same toString()", type4);
    }
}

